@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.inputs

import com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigSidecarInjectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property autoInjectionPolicyEnabled Whether to enable by Pod Annotations automatic injection Sidecar.
 * @property enableNamespacesByDefault Whether it is the all namespaces you turn on the auto injection capabilities.
 * @property initCniConfiguration CNI configuration. See `init_cni_configuration` below.
 * @property limitCpu Sidecar injector Pods on the throttle.
 * @property limitMemory Sidecar injector Pods on the throttle.
 * @property requestCpu Sidecar injector Pods on the requested resource.
 * @property requestMemory Sidecar injector Pods on the requested resource.
 * @property sidecarInjectorWebhookAsYaml Other automatic injection Sidecar configuration (in YAML format).
 */
public data class ServiceMeshMeshConfigSidecarInjectorArgs(
    public val autoInjectionPolicyEnabled: Output<Boolean>? = null,
    public val enableNamespacesByDefault: Output<Boolean>? = null,
    public val initCniConfiguration: Output<ServiceMeshMeshConfigSidecarInjectorInitCniConfigurationArgs>? = null,
    public val limitCpu: Output<String>? = null,
    public val limitMemory: Output<String>? = null,
    public val requestCpu: Output<String>? = null,
    public val requestMemory: Output<String>? = null,
    public val sidecarInjectorWebhookAsYaml: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigSidecarInjectorArgs> {
    override fun toJava(): com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigSidecarInjectorArgs =
        com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigSidecarInjectorArgs.builder()
            .autoInjectionPolicyEnabled(autoInjectionPolicyEnabled?.applyValue({ args0 -> args0 }))
            .enableNamespacesByDefault(enableNamespacesByDefault?.applyValue({ args0 -> args0 }))
            .initCniConfiguration(
                initCniConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .limitCpu(limitCpu?.applyValue({ args0 -> args0 }))
            .limitMemory(limitMemory?.applyValue({ args0 -> args0 }))
            .requestCpu(requestCpu?.applyValue({ args0 -> args0 }))
            .requestMemory(requestMemory?.applyValue({ args0 -> args0 }))
            .sidecarInjectorWebhookAsYaml(sidecarInjectorWebhookAsYaml?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceMeshMeshConfigSidecarInjectorArgs].
 */
@PulumiTagMarker
public class ServiceMeshMeshConfigSidecarInjectorArgsBuilder internal constructor() {
    private var autoInjectionPolicyEnabled: Output<Boolean>? = null

    private var enableNamespacesByDefault: Output<Boolean>? = null

    private var initCniConfiguration:
        Output<ServiceMeshMeshConfigSidecarInjectorInitCniConfigurationArgs>? = null

    private var limitCpu: Output<String>? = null

    private var limitMemory: Output<String>? = null

    private var requestCpu: Output<String>? = null

    private var requestMemory: Output<String>? = null

    private var sidecarInjectorWebhookAsYaml: Output<String>? = null

    /**
     * @param value Whether to enable by Pod Annotations automatic injection Sidecar.
     */
    @JvmName("sdcdmnrtexbwasjb")
    public suspend fun autoInjectionPolicyEnabled(`value`: Output<Boolean>) {
        this.autoInjectionPolicyEnabled = value
    }

    /**
     * @param value Whether it is the all namespaces you turn on the auto injection capabilities.
     */
    @JvmName("jjihltmmxckyplij")
    public suspend fun enableNamespacesByDefault(`value`: Output<Boolean>) {
        this.enableNamespacesByDefault = value
    }

    /**
     * @param value CNI configuration. See `init_cni_configuration` below.
     */
    @JvmName("vjxdexdvfmwgnehh")
    public suspend fun initCniConfiguration(`value`: Output<ServiceMeshMeshConfigSidecarInjectorInitCniConfigurationArgs>) {
        this.initCniConfiguration = value
    }

    /**
     * @param value Sidecar injector Pods on the throttle.
     */
    @JvmName("djgbuwhidfwipdep")
    public suspend fun limitCpu(`value`: Output<String>) {
        this.limitCpu = value
    }

    /**
     * @param value Sidecar injector Pods on the throttle.
     */
    @JvmName("cyvkjbivitapbpjy")
    public suspend fun limitMemory(`value`: Output<String>) {
        this.limitMemory = value
    }

    /**
     * @param value Sidecar injector Pods on the requested resource.
     */
    @JvmName("rhccfxrbjoprrlul")
    public suspend fun requestCpu(`value`: Output<String>) {
        this.requestCpu = value
    }

    /**
     * @param value Sidecar injector Pods on the requested resource.
     */
    @JvmName("shyykomgslhmnhfr")
    public suspend fun requestMemory(`value`: Output<String>) {
        this.requestMemory = value
    }

    /**
     * @param value Other automatic injection Sidecar configuration (in YAML format).
     */
    @JvmName("vmnhijwtcebooict")
    public suspend fun sidecarInjectorWebhookAsYaml(`value`: Output<String>) {
        this.sidecarInjectorWebhookAsYaml = value
    }

    /**
     * @param value Whether to enable by Pod Annotations automatic injection Sidecar.
     */
    @JvmName("aiiksfulmulqhjlo")
    public suspend fun autoInjectionPolicyEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoInjectionPolicyEnabled = mapped
    }

    /**
     * @param value Whether it is the all namespaces you turn on the auto injection capabilities.
     */
    @JvmName("vbtutjepisajihsp")
    public suspend fun enableNamespacesByDefault(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableNamespacesByDefault = mapped
    }

    /**
     * @param value CNI configuration. See `init_cni_configuration` below.
     */
    @JvmName("rfwoedqffukntehg")
    public suspend fun initCniConfiguration(`value`: ServiceMeshMeshConfigSidecarInjectorInitCniConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initCniConfiguration = mapped
    }

    /**
     * @param argument CNI configuration. See `init_cni_configuration` below.
     */
    @JvmName("svvwdlxwjrfkgcsu")
    public suspend fun initCniConfiguration(argument: suspend ServiceMeshMeshConfigSidecarInjectorInitCniConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ServiceMeshMeshConfigSidecarInjectorInitCniConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.initCniConfiguration = mapped
    }

    /**
     * @param value Sidecar injector Pods on the throttle.
     */
    @JvmName("ygaeujjwrkhwqsnw")
    public suspend fun limitCpu(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limitCpu = mapped
    }

    /**
     * @param value Sidecar injector Pods on the throttle.
     */
    @JvmName("ryyihwbwcfimadix")
    public suspend fun limitMemory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limitMemory = mapped
    }

    /**
     * @param value Sidecar injector Pods on the requested resource.
     */
    @JvmName("yqttqtlvffqceojj")
    public suspend fun requestCpu(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestCpu = mapped
    }

    /**
     * @param value Sidecar injector Pods on the requested resource.
     */
    @JvmName("fyfjupwlvyftemux")
    public suspend fun requestMemory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestMemory = mapped
    }

    /**
     * @param value Other automatic injection Sidecar configuration (in YAML format).
     */
    @JvmName("irsxgknyhejrcopp")
    public suspend fun sidecarInjectorWebhookAsYaml(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sidecarInjectorWebhookAsYaml = mapped
    }

    internal fun build(): ServiceMeshMeshConfigSidecarInjectorArgs =
        ServiceMeshMeshConfigSidecarInjectorArgs(
            autoInjectionPolicyEnabled = autoInjectionPolicyEnabled,
            enableNamespacesByDefault = enableNamespacesByDefault,
            initCniConfiguration = initCniConfiguration,
            limitCpu = limitCpu,
            limitMemory = limitMemory,
            requestCpu = requestCpu,
            requestMemory = requestMemory,
            sidecarInjectorWebhookAsYaml = sidecarInjectorWebhookAsYaml,
        )
}
