@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.inputs

import com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigSidecarInjectorInitCniConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enable CNI.
 * @property excludeNamespaces The excluded namespace.
 */
public data class ServiceMeshMeshConfigSidecarInjectorInitCniConfigurationArgs(
    public val enabled: Output<Boolean>? = null,
    public val excludeNamespaces: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigSidecarInjectorInitCniConfigurationArgs> {
    override fun toJava(): com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigSidecarInjectorInitCniConfigurationArgs =
        com.pulumi.alicloud.servicemesh.inputs.ServiceMeshMeshConfigSidecarInjectorInitCniConfigurationArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .excludeNamespaces(excludeNamespaces?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceMeshMeshConfigSidecarInjectorInitCniConfigurationArgs].
 */
@PulumiTagMarker
public class ServiceMeshMeshConfigSidecarInjectorInitCniConfigurationArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var excludeNamespaces: Output<String>? = null

    /**
     * @param value Enable CNI.
     */
    @JvmName("xliyftqibfixnuju")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The excluded namespace.
     */
    @JvmName("gbfixoaiebmlrmya")
    public suspend fun excludeNamespaces(`value`: Output<String>) {
        this.excludeNamespaces = value
    }

    /**
     * @param value Enable CNI.
     */
    @JvmName("frudxwatlpyygtsb")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The excluded namespace.
     */
    @JvmName("xnyqammwboksnffp")
    public suspend fun excludeNamespaces(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludeNamespaces = mapped
    }

    internal fun build(): ServiceMeshMeshConfigSidecarInjectorInitCniConfigurationArgs =
        ServiceMeshMeshConfigSidecarInjectorInitCniConfigurationArgs(
            enabled = enabled,
            excludeNamespaces = excludeNamespaces,
        )
}
