@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.inputs

import com.pulumi.alicloud.servicemesh.inputs.ServiceMeshNetworkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property securityGroupId Security group ID.
 * @property vpcId VPC ID.
 * @property vswitcheList Virtual Switch ID.
 */
public data class ServiceMeshNetworkArgs(
    public val securityGroupId: Output<String>? = null,
    public val vpcId: Output<String>,
    public val vswitcheList: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.servicemesh.inputs.ServiceMeshNetworkArgs> {
    override fun toJava(): com.pulumi.alicloud.servicemesh.inputs.ServiceMeshNetworkArgs =
        com.pulumi.alicloud.servicemesh.inputs.ServiceMeshNetworkArgs.builder()
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId.applyValue({ args0 -> args0 }))
            .vswitcheList(vswitcheList.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceMeshNetworkArgs].
 */
@PulumiTagMarker
public class ServiceMeshNetworkArgsBuilder internal constructor() {
    private var securityGroupId: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vswitcheList: Output<String>? = null

    /**
     * @param value Security group ID.
     */
    @JvmName("kfbbirwgmjqlxkfp")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value VPC ID.
     */
    @JvmName("edsswxtwrifbaheb")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value Virtual Switch ID.
     */
    @JvmName("gjrivopxhnuifsfe")
    public suspend fun vswitcheList(`value`: Output<String>) {
        this.vswitcheList = value
    }

    /**
     * @param value Security group ID.
     */
    @JvmName("airyjfkbqbiieoem")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value VPC ID.
     */
    @JvmName("qesmnoupgndgggsy")
    public suspend fun vpcId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value Virtual Switch ID.
     */
    @JvmName("pgmqimsoqplrmmwi")
    public suspend fun vswitcheList(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vswitcheList = mapped
    }

    internal fun build(): ServiceMeshNetworkArgs = ServiceMeshNetworkArgs(
        securityGroupId = securityGroupId,
        vpcId = vpcId ?: throw PulumiNullFieldException("vpcId"),
        vswitcheList = vswitcheList ?: throw PulumiNullFieldException("vswitcheList"),
    )
}
