@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.inputs

import com.pulumi.alicloud.servicemesh.inputs.UserPermissionPermissionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property isCustom Whether the grant object is a RAM role.
 * @property isRamRole Whether the grant object is an entity.
 * @property roleName The permission name. Valid values: `istio-admin`, `istio-ops`, `istio-readonly`.
 * - `istio-admin`:  The administrator.
 * - `istio-ops`: The administrator of the service mesh resource.
 * - `istio-readonly`: The read only permission.
 * @property roleType The role type. Valid Value: `custom`.
 * @property serviceMeshId The service mesh id.
 */
public data class UserPermissionPermissionArgs(
    public val isCustom: Output<Boolean>? = null,
    public val isRamRole: Output<Boolean>? = null,
    public val roleName: Output<String>? = null,
    public val roleType: Output<String>? = null,
    public val serviceMeshId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.servicemesh.inputs.UserPermissionPermissionArgs> {
    override fun toJava(): com.pulumi.alicloud.servicemesh.inputs.UserPermissionPermissionArgs =
        com.pulumi.alicloud.servicemesh.inputs.UserPermissionPermissionArgs.builder()
            .isCustom(isCustom?.applyValue({ args0 -> args0 }))
            .isRamRole(isRamRole?.applyValue({ args0 -> args0 }))
            .roleName(roleName?.applyValue({ args0 -> args0 }))
            .roleType(roleType?.applyValue({ args0 -> args0 }))
            .serviceMeshId(serviceMeshId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserPermissionPermissionArgs].
 */
@PulumiTagMarker
public class UserPermissionPermissionArgsBuilder internal constructor() {
    private var isCustom: Output<Boolean>? = null

    private var isRamRole: Output<Boolean>? = null

    private var roleName: Output<String>? = null

    private var roleType: Output<String>? = null

    private var serviceMeshId: Output<String>? = null

    /**
     * @param value Whether the grant object is a RAM role.
     */
    @JvmName("kdgjfgjjyfeyrflc")
    public suspend fun isCustom(`value`: Output<Boolean>) {
        this.isCustom = value
    }

    /**
     * @param value Whether the grant object is an entity.
     */
    @JvmName("nhiyacxomlgtfbgl")
    public suspend fun isRamRole(`value`: Output<Boolean>) {
        this.isRamRole = value
    }

    /**
     * @param value The permission name. Valid values: `istio-admin`, `istio-ops`, `istio-readonly`.
     * - `istio-admin`:  The administrator.
     * - `istio-ops`: The administrator of the service mesh resource.
     * - `istio-readonly`: The read only permission.
     */
    @JvmName("flhjdivlwhopjcfm")
    public suspend fun roleName(`value`: Output<String>) {
        this.roleName = value
    }

    /**
     * @param value The role type. Valid Value: `custom`.
     */
    @JvmName("uwtonxlkwnhubcxp")
    public suspend fun roleType(`value`: Output<String>) {
        this.roleType = value
    }

    /**
     * @param value The service mesh id.
     */
    @JvmName("jbjlakffhkdkychy")
    public suspend fun serviceMeshId(`value`: Output<String>) {
        this.serviceMeshId = value
    }

    /**
     * @param value Whether the grant object is a RAM role.
     */
    @JvmName("gdwkbtuyjvvhehsa")
    public suspend fun isCustom(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isCustom = mapped
    }

    /**
     * @param value Whether the grant object is an entity.
     */
    @JvmName("swuvsscdywbaokip")
    public suspend fun isRamRole(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isRamRole = mapped
    }

    /**
     * @param value The permission name. Valid values: `istio-admin`, `istio-ops`, `istio-readonly`.
     * - `istio-admin`:  The administrator.
     * - `istio-ops`: The administrator of the service mesh resource.
     * - `istio-readonly`: The read only permission.
     */
    @JvmName("gwjwjhyqsivscifj")
    public suspend fun roleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleName = mapped
    }

    /**
     * @param value The role type. Valid Value: `custom`.
     */
    @JvmName("eysnejdiktrfpmkx")
    public suspend fun roleType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleType = mapped
    }

    /**
     * @param value The service mesh id.
     */
    @JvmName("pimmpdbgkncspxgr")
    public suspend fun serviceMeshId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceMeshId = mapped
    }

    internal fun build(): UserPermissionPermissionArgs = UserPermissionPermissionArgs(
        isCustom = isCustom,
        isRamRole = isRamRole,
        roleName = roleName,
        roleType = roleType,
        serviceMeshId = serviceMeshId,
    )
}
