@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property config The config of the Service Mesh Extension Provider.
 * @property extensionProviderName The name of the Service Mesh Extension Provider.
 * @property id The ID of the Service Mesh Extension Provider. It formats as `<service_mesh_id>:<type>:<extension_provider_name>`.
 * @property serviceMeshId The ID of the Service Mesh.
 * @property type The type of the Service Mesh Extension Provider. Valid values: `httpextauth`, `grpcextauth`.
 */
public data class GetExtensionProvidersProvider(
    public val config: String,
    public val extensionProviderName: String,
    public val id: String,
    public val serviceMeshId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicemesh.outputs.GetExtensionProvidersProvider): GetExtensionProvidersProvider = GetExtensionProvidersProvider(
            config = javaType.config(),
            extensionProviderName = javaType.extensionProviderName(),
            id = javaType.id(),
            serviceMeshId = javaType.serviceMeshId(),
            type = javaType.type(),
        )
    }
}
