@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getExtensionProviders.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names A list of Extension Provider names.
 * @property outputFile
 * @property providers A list of Service Mesh Extension Providers. Each element contains the following attributes:
 * @property serviceMeshId The ID of the Service Mesh.
 * @property type The type of the Service Mesh Extension Provider.
 */
public data class GetExtensionProvidersResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val providers: List<GetExtensionProvidersProvider>,
    public val serviceMeshId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicemesh.outputs.GetExtensionProvidersResult): GetExtensionProvidersResult = GetExtensionProvidersResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            providers = javaType.providers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicemesh.kotlin.outputs.GetExtensionProvidersProvider.Companion.toKotlin(args0)
                })
            }),
            serviceMeshId = javaType.serviceMeshId(),
            type = javaType.type(),
        )
    }
}
