@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property clusters The Cluster List.
 * @property createTime The created time of the Service Mesh instance.
 * @property edition Grid instance version type. **Note:** `edition` takes effect only if `enable_details` is set to `true`.
 * @property endpoints The endpoint details. **Note:** `endpoints` takes effect only if `enable_details` is set to `true`.
 * @property errorMessage The returned error message.
 * @property id The ID of the Service Mesh instance.
 * @property istioOperatorVersion (Available since v1.170.0) The Istio Operator Version. **Note:** `istio_operator_version` takes effect only if `enable_details` is set to `true`.
 * @property kubeConfig The content of Kube config. **Note:** `kube_config` takes effect only if `enable_details` is set to `true`.
 * @property loadBalancers The configuration of the Load Balancer. **Note:** `load_balancer` takes effect only if `enable_details` is set to `true`.
 * @property meshConfigs The configuration of the Service grid. **Note:** `mesh_config` takes effect only if `enable_details` is set to `true`.
 * @property networks The configuration of the Service grid network. **Note:** `network` takes effect only if `enable_details` is set to `true`.
 * @property serviceMeshId The ID of the Service Mesh instance.
 * @property serviceMeshName The name of the Service Mesh instance.
 * @property sidecarVersion (Available since v1.170.0) The SideCar Version. **Note:** `sidecar_version` takes effect only if `enable_details` is set to `true`.
 * @property status The status of the Service Mesh. Valid values: `running`, `initial`.
 * @property version The version of the Service Mesh instance.
 */
public data class GetServiceMeshesMesh(
    public val clusters: List<String>,
    public val createTime: String,
    public val edition: String,
    public val endpoints: List<GetServiceMeshesMeshEndpoint>,
    public val errorMessage: String,
    public val id: String,
    public val istioOperatorVersion: String,
    public val kubeConfig: String,
    public val loadBalancers: List<GetServiceMeshesMeshLoadBalancer>,
    public val meshConfigs: List<GetServiceMeshesMeshMeshConfig>,
    public val networks: List<GetServiceMeshesMeshNetwork>,
    public val serviceMeshId: String,
    public val serviceMeshName: String,
    public val sidecarVersion: String,
    public val status: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicemesh.outputs.GetServiceMeshesMesh): GetServiceMeshesMesh = GetServiceMeshesMesh(
            clusters = javaType.clusters().map({ args0 -> args0 }),
            createTime = javaType.createTime(),
            edition = javaType.edition(),
            endpoints = javaType.endpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicemesh.kotlin.outputs.GetServiceMeshesMeshEndpoint.Companion.toKotlin(args0)
                })
            }),
            errorMessage = javaType.errorMessage(),
            id = javaType.id(),
            istioOperatorVersion = javaType.istioOperatorVersion(),
            kubeConfig = javaType.kubeConfig(),
            loadBalancers = javaType.loadBalancers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicemesh.kotlin.outputs.GetServiceMeshesMeshLoadBalancer.Companion.toKotlin(args0)
                })
            }),
            meshConfigs = javaType.meshConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicemesh.kotlin.outputs.GetServiceMeshesMeshMeshConfig.Companion.toKotlin(args0)
                })
            }),
            networks = javaType.networks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicemesh.kotlin.outputs.GetServiceMeshesMeshNetwork.Companion.toKotlin(args0)
                })
            }),
            serviceMeshId = javaType.serviceMeshId(),
            serviceMeshName = javaType.serviceMeshName(),
            sidecarVersion = javaType.sidecarVersion(),
            status = javaType.status(),
            version = javaType.version(),
        )
    }
}
