@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property intranetApiServerEndpoint The internal address of the API Server.
 * @property intranetPilotEndpoint The internal address of the Istio Pilot.
 * @property publicApiServerEndpoint The public address of the API Server.
 * @property publicPilotEndpoint The public address of the Istio Pilot.
 */
public data class GetServiceMeshesMeshEndpoint(
    public val intranetApiServerEndpoint: String,
    public val intranetPilotEndpoint: String,
    public val publicApiServerEndpoint: String,
    public val publicPilotEndpoint: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicemesh.outputs.GetServiceMeshesMeshEndpoint): GetServiceMeshesMeshEndpoint = GetServiceMeshesMeshEndpoint(
            intranetApiServerEndpoint = javaType.intranetApiServerEndpoint(),
            intranetPilotEndpoint = javaType.intranetPilotEndpoint(),
            publicApiServerEndpoint = javaType.publicApiServerEndpoint(),
            publicPilotEndpoint = javaType.publicPilotEndpoint(),
        )
    }
}
