@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property apiServerLoadbalancerId The IP address of a public network exposed API Server corresponding to the Load Balance.
 * @property apiServerPublicEip Whether to use the IP address of a public network exposed the API Server.
 * @property pilotPublicEip Whether to use the IP address of a public network exposure the Istio Pilot.
 * @property pilotPublicLoadbalancerId The IP address of a public network exposure Istio Pilot corresponds to the Load Balance.
 */
public data class GetServiceMeshesMeshLoadBalancer(
    public val apiServerLoadbalancerId: String,
    public val apiServerPublicEip: Boolean,
    public val pilotPublicEip: Boolean,
    public val pilotPublicLoadbalancerId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicemesh.outputs.GetServiceMeshesMeshLoadBalancer): GetServiceMeshesMeshLoadBalancer = GetServiceMeshesMeshLoadBalancer(
            apiServerLoadbalancerId = javaType.apiServerLoadbalancerId(),
            apiServerPublicEip = javaType.apiServerPublicEip(),
            pilotPublicEip = javaType.pilotPublicEip(),
            pilotPublicLoadbalancerId = javaType.pilotPublicLoadbalancerId(),
        )
    }
}
