@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accessLogs The configuration of the access logging.
 * @property audits The configuration of the Service grid audit.
 * @property controlPlaneLogs (Available since v1.174.0) The configuration of the control plane logging.
 * @property customizedZipkin Whether or not to enable the use of a custom zipkin.
 * @property enableLocalityLb Whether to enable service can access the service through the nearest node access.
 * @property includeIpRanges The IP ADDRESS range.
 * @property kialis The configuration of the Kiali.
 * @property opas The open-door policy of agent (OPA) plug-in information.
 * @property outboundTrafficPolicy The policy of the Out to the traffic.
 * @property pilots The configuration of the Link trace sampling.
 * @property prometheuses the configuration of the Prometheus.
 * @property proxies The configuration of the Proxy.
 * @property sidecarInjectors The configuration of the Sidecar injector.
 * @property telemetry Whether to enable acquisition Prometheus metrics.
 * @property tracing Whether to enable link trace.
 */
public data class GetServiceMeshesMeshMeshConfig(
    public val accessLogs: List<GetServiceMeshesMeshMeshConfigAccessLog>,
    public val audits: List<GetServiceMeshesMeshMeshConfigAudit>,
    public val controlPlaneLogs: List<GetServiceMeshesMeshMeshConfigControlPlaneLog>,
    public val customizedZipkin: Boolean,
    public val enableLocalityLb: Boolean,
    public val includeIpRanges: String,
    public val kialis: List<GetServiceMeshesMeshMeshConfigKiali>,
    public val opas: List<GetServiceMeshesMeshMeshConfigOpa>,
    public val outboundTrafficPolicy: String,
    public val pilots: List<GetServiceMeshesMeshMeshConfigPilot>,
    public val prometheuses: List<GetServiceMeshesMeshMeshConfigPrometheus>,
    public val proxies: List<GetServiceMeshesMeshMeshConfigProxy>,
    public val sidecarInjectors: List<GetServiceMeshesMeshMeshConfigSidecarInjector>,
    public val telemetry: Boolean,
    public val tracing: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicemesh.outputs.GetServiceMeshesMeshMeshConfig): GetServiceMeshesMeshMeshConfig = GetServiceMeshesMeshMeshConfig(
            accessLogs = javaType.accessLogs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicemesh.kotlin.outputs.GetServiceMeshesMeshMeshConfigAccessLog.Companion.toKotlin(args0)
                })
            }),
            audits = javaType.audits().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicemesh.kotlin.outputs.GetServiceMeshesMeshMeshConfigAudit.Companion.toKotlin(args0)
                })
            }),
            controlPlaneLogs = javaType.controlPlaneLogs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicemesh.kotlin.outputs.GetServiceMeshesMeshMeshConfigControlPlaneLog.Companion.toKotlin(args0)
                })
            }),
            customizedZipkin = javaType.customizedZipkin(),
            enableLocalityLb = javaType.enableLocalityLb(),
            includeIpRanges = javaType.includeIpRanges(),
            kialis = javaType.kialis().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicemesh.kotlin.outputs.GetServiceMeshesMeshMeshConfigKiali.Companion.toKotlin(args0)
                })
            }),
            opas = javaType.opas().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicemesh.kotlin.outputs.GetServiceMeshesMeshMeshConfigOpa.Companion.toKotlin(args0)
                })
            }),
            outboundTrafficPolicy = javaType.outboundTrafficPolicy(),
            pilots = javaType.pilots().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicemesh.kotlin.outputs.GetServiceMeshesMeshMeshConfigPilot.Companion.toKotlin(args0)
                })
            }),
            prometheuses = javaType.prometheuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicemesh.kotlin.outputs.GetServiceMeshesMeshMeshConfigPrometheus.Companion.toKotlin(args0)
                })
            }),
            proxies = javaType.proxies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicemesh.kotlin.outputs.GetServiceMeshesMeshMeshConfigProxy.Companion.toKotlin(args0)
                })
            }),
            sidecarInjectors = javaType.sidecarInjectors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicemesh.kotlin.outputs.GetServiceMeshesMeshMeshConfigSidecarInjector.Companion.toKotlin(args0)
                })
            }),
            telemetry = javaType.telemetry(),
            tracing = javaType.tracing(),
        )
    }
}
