@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enabled Whether to enable CNI.
 * @property limitCpu Sidecar injector Pods on the throttle.
 * @property limitMemory The memory limit  of the Sidecar injector Pods.
 * @property logLevel The log level of the OPA proxy container .
 * @property requestCpu The requested cpu the Sidecar injector Pods.
 * @property requestMemory The requested memory the Sidecar injector Pods.
 */
public data class GetServiceMeshesMeshMeshConfigOpa(
    public val enabled: Boolean,
    public val limitCpu: String,
    public val limitMemory: String,
    public val logLevel: String,
    public val requestCpu: String,
    public val requestMemory: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicemesh.outputs.GetServiceMeshesMeshMeshConfigOpa): GetServiceMeshesMeshMeshConfigOpa = GetServiceMeshesMeshMeshConfigOpa(
            enabled = javaType.enabled(),
            limitCpu = javaType.limitCpu(),
            limitMemory = javaType.limitMemory(),
            logLevel = javaType.logLevel(),
            requestCpu = javaType.requestCpu(),
            requestMemory = javaType.requestMemory(),
        )
    }
}
