@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property clusterDomain The domain name of the Cluster.
 * @property limitCpu Sidecar injector Pods on the throttle.
 * @property limitMemory The memory limit  of the Sidecar injector Pods.
 * @property requestCpu The requested cpu the Sidecar injector Pods.
 * @property requestMemory The requested memory the Sidecar injector Pods.
 */
public data class GetServiceMeshesMeshMeshConfigProxy(
    public val clusterDomain: String,
    public val limitCpu: String,
    public val limitMemory: String,
    public val requestCpu: String,
    public val requestMemory: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicemesh.outputs.GetServiceMeshesMeshMeshConfigProxy): GetServiceMeshesMeshMeshConfigProxy = GetServiceMeshesMeshMeshConfigProxy(
            clusterDomain = javaType.clusterDomain(),
            limitCpu = javaType.limitCpu(),
            limitMemory = javaType.limitMemory(),
            requestCpu = javaType.requestCpu(),
            requestMemory = javaType.requestMemory(),
        )
    }
}
