@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property autoInjectionPolicyEnabled Whether to enable by Pod Annotations automatic injection Sidecar.
 * @property enableNamespacesByDefault Whether it is the all namespaces you turn on the auto injection capabilities.
 * @property initCniConfigurations The configuration of the CNI
 * @property limitCpu Sidecar injector Pods on the throttle.
 * @property limitMemory The memory limit  of the Sidecar injector Pods.
 * @property requestCpu The requested cpu the Sidecar injector Pods.
 * @property requestMemory The requested memory the Sidecar injector Pods.
 * @property sidecarInjectorWebhookAsYaml Other automatic injection Sidecar configuration (in YAML format).
 */
public data class GetServiceMeshesMeshMeshConfigSidecarInjector(
    public val autoInjectionPolicyEnabled: Boolean,
    public val enableNamespacesByDefault: Boolean,
    public val initCniConfigurations: List<GetServiceMeshesMeshMeshConfigSidecarInjectorInitCniConfiguration>,
    public val limitCpu: String,
    public val limitMemory: String,
    public val requestCpu: String,
    public val requestMemory: String,
    public val sidecarInjectorWebhookAsYaml: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicemesh.outputs.GetServiceMeshesMeshMeshConfigSidecarInjector): GetServiceMeshesMeshMeshConfigSidecarInjector =
            GetServiceMeshesMeshMeshConfigSidecarInjector(
                autoInjectionPolicyEnabled = javaType.autoInjectionPolicyEnabled(),
                enableNamespacesByDefault = javaType.enableNamespacesByDefault(),
                initCniConfigurations = javaType.initCniConfigurations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.servicemesh.kotlin.outputs.GetServiceMeshesMeshMeshConfigSidecarInjectorInitCniConfiguration.Companion.toKotlin(args0)
                    })
                }),
                limitCpu = javaType.limitCpu(),
                limitMemory = javaType.limitMemory(),
                requestCpu = javaType.requestCpu(),
                requestMemory = javaType.requestMemory(),
                sidecarInjectorWebhookAsYaml = javaType.sidecarInjectorWebhookAsYaml(),
            )
    }
}
