@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property securityGroupId The ID of the Security group
 * @property vpcId The ID of the VPC.
 * @property vswitcheLists The list of Virtual Switch.
 */
public data class GetServiceMeshesMeshNetwork(
    public val securityGroupId: String,
    public val vpcId: String,
    public val vswitcheLists: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicemesh.outputs.GetServiceMeshesMeshNetwork): GetServiceMeshesMeshNetwork = GetServiceMeshesMeshNetwork(
            securityGroupId = javaType.securityGroupId(),
            vpcId = javaType.vpcId(),
            vswitcheLists = javaType.vswitcheLists().map({ args0 -> args0 }),
        )
    }
}
