@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property edition The edition of the ASM instance. Valid values:
 * - Default: Standard Edition
 * - Pro: Professional Edition
 * @property id The ASM version id. It formats as `<edition>:<version>`.
 * @property version A list of Service Mesh Service Meshes. Each element contains the following attributes:
 */
public data class GetVersionsVersion(
    public val edition: String,
    public val id: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicemesh.outputs.GetVersionsVersion): GetVersionsVersion = GetVersionsVersion(
            edition = javaType.edition(),
            id = javaType.id(),
            version = javaType.version(),
        )
    }
}
