@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property apiServerLoadbalancerId The Instance ID of APIServer Load Balancer.
 * @property apiServerPublicEip Indicates whether to use the IP address of a public network exposed API Server.
 * @property pilotPublicEip Indicates whether to use the IP address of a public network exposure Istio Pilot.
 * @property pilotPublicLoadbalancerId The Instance ID of Pilot Load Balancer.
 */
public data class ServiceMeshLoadBalancer(
    public val apiServerLoadbalancerId: String? = null,
    public val apiServerPublicEip: Boolean? = null,
    public val pilotPublicEip: Boolean? = null,
    public val pilotPublicLoadbalancerId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicemesh.outputs.ServiceMeshLoadBalancer): ServiceMeshLoadBalancer = ServiceMeshLoadBalancer(
            apiServerLoadbalancerId = javaType.apiServerLoadbalancerId().map({ args0 -> args0 }).orElse(null),
            apiServerPublicEip = javaType.apiServerPublicEip().map({ args0 -> args0 }).orElse(null),
            pilotPublicEip = javaType.pilotPublicEip().map({ args0 -> args0 }).orElse(null),
            pilotPublicLoadbalancerId = javaType.pilotPublicLoadbalancerId().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
