@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessLog The access logging configuration. See `access_log` below.
 * @property audit Audit information. See `audit` below.
 * @property controlPlaneLog Control plane log collection configuration. See `control_plane_log` below.
 * @property customizedZipkin Whether or not to enable the use of a custom zipkin.
 * @property enableLocalityLb Whether to enable service can access the service through the nearest node access.
 * @property includeIpRanges The IP ADDRESS range.
 * @property kiali Kiali configuration. See `kiali` below.
 * @property opa The open-door policy of agent (OPA) plug-in information. See `opa` below.
 * @property outboundTrafficPolicy Out to the traffic policy.
 * @property pilot Link trace sampling information. See `pilot` below.
 * @property prometheus Prometheus configuration.
 * @property proxy Proxy configuration. See `proxy` below.
 * @property sidecarInjector Sidecar injector configuration. See `sidecar_injector` below.
 * @property telemetry Whether to enable acquisition Prometheus metrics (it is recommended that you use [Alibaba Cloud Prometheus monitoring](https://arms.console.aliyun.com/).
 * @property tracing Whether to enable link trace (you need to have [Alibaba Cloud link tracking service](https://tracing-analysis.console.aliyun.com/).
 */
public data class ServiceMeshMeshConfig(
    public val accessLog: ServiceMeshMeshConfigAccessLog? = null,
    public val audit: ServiceMeshMeshConfigAudit? = null,
    public val controlPlaneLog: ServiceMeshMeshConfigControlPlaneLog? = null,
    public val customizedZipkin: Boolean? = null,
    public val enableLocalityLb: Boolean? = null,
    public val includeIpRanges: String? = null,
    public val kiali: ServiceMeshMeshConfigKiali? = null,
    public val opa: ServiceMeshMeshConfigOpa? = null,
    public val outboundTrafficPolicy: String? = null,
    public val pilot: ServiceMeshMeshConfigPilot? = null,
    public val prometheus: ServiceMeshMeshConfigPrometheus? = null,
    public val proxy: ServiceMeshMeshConfigProxy? = null,
    public val sidecarInjector: ServiceMeshMeshConfigSidecarInjector? = null,
    public val telemetry: Boolean? = null,
    public val tracing: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicemesh.outputs.ServiceMeshMeshConfig): ServiceMeshMeshConfig = ServiceMeshMeshConfig(
            accessLog = javaType.accessLog().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicemesh.kotlin.outputs.ServiceMeshMeshConfigAccessLog.Companion.toKotlin(args0)
                })
            }).orElse(null),
            audit = javaType.audit().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicemesh.kotlin.outputs.ServiceMeshMeshConfigAudit.Companion.toKotlin(args0)
                })
            }).orElse(null),
            controlPlaneLog = javaType.controlPlaneLog().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicemesh.kotlin.outputs.ServiceMeshMeshConfigControlPlaneLog.Companion.toKotlin(args0)
                })
            }).orElse(null),
            customizedZipkin = javaType.customizedZipkin().map({ args0 -> args0 }).orElse(null),
            enableLocalityLb = javaType.enableLocalityLb().map({ args0 -> args0 }).orElse(null),
            includeIpRanges = javaType.includeIpRanges().map({ args0 -> args0 }).orElse(null),
            kiali = javaType.kiali().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicemesh.kotlin.outputs.ServiceMeshMeshConfigKiali.Companion.toKotlin(args0)
                })
            }).orElse(null),
            opa = javaType.opa().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicemesh.kotlin.outputs.ServiceMeshMeshConfigOpa.Companion.toKotlin(args0)
                })
            }).orElse(null),
            outboundTrafficPolicy = javaType.outboundTrafficPolicy().map({ args0 -> args0 }).orElse(null),
            pilot = javaType.pilot().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicemesh.kotlin.outputs.ServiceMeshMeshConfigPilot.Companion.toKotlin(args0)
                })
            }).orElse(null),
            prometheus = javaType.prometheus().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicemesh.kotlin.outputs.ServiceMeshMeshConfigPrometheus.Companion.toKotlin(args0)
                })
            }).orElse(null),
            proxy = javaType.proxy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicemesh.kotlin.outputs.ServiceMeshMeshConfigProxy.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sidecarInjector = javaType.sidecarInjector().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicemesh.kotlin.outputs.ServiceMeshMeshConfigSidecarInjector.Companion.toKotlin(args0)
                })
            }).orElse(null),
            telemetry = javaType.telemetry().map({ args0 -> args0 }).orElse(null),
            tracing = javaType.tracing().map({ args0 -> args0 }).orElse(null),
        )
    }
}
