@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enabled Enable CNI.
 * @property gatewayEnabled Whether collect AccessLog of ASM Gateway to Alibaba Cloud SLS.
 * @property gatewayLifecycle Lifecycle of AccessLog of ASM Gateways which have been collected to Alibaba Cloud SLS.
 * @property project The name of the SLS Project to which the control plane logs are collected.
 * @property sidecarEnabled Whether collect AccessLog of ASM Gateway to Alibaba Cloud SLS.
 * @property sidecarLifecycle Lifecycle of AccessLog of ASM Sidecars which have been collected to Alibaba Cloud SLS.
 */
public data class ServiceMeshMeshConfigAccessLog(
    public val enabled: Boolean? = null,
    public val gatewayEnabled: Boolean? = null,
    public val gatewayLifecycle: Int? = null,
    public val project: String? = null,
    public val sidecarEnabled: Boolean? = null,
    public val sidecarLifecycle: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicemesh.outputs.ServiceMeshMeshConfigAccessLog): ServiceMeshMeshConfigAccessLog = ServiceMeshMeshConfigAccessLog(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            gatewayEnabled = javaType.gatewayEnabled().map({ args0 -> args0 }).orElse(null),
            gatewayLifecycle = javaType.gatewayLifecycle().map({ args0 -> args0 }).orElse(null),
            project = javaType.project().map({ args0 -> args0 }).orElse(null),
            sidecarEnabled = javaType.sidecarEnabled().map({ args0 -> args0 }).orElse(null),
            sidecarLifecycle = javaType.sidecarLifecycle().map({ args0 -> args0 }).orElse(null),
        )
    }
}
