@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enabled Enable CNI.
 * @property logTtlInDay Lifecycle of logs has been collected to Alibaba Cloud SLS.
 * @property project The name of the SLS Project to which the control plane logs are collected.
 */
public data class ServiceMeshMeshConfigControlPlaneLog(
    public val enabled: Boolean,
    public val logTtlInDay: Int? = null,
    public val project: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicemesh.outputs.ServiceMeshMeshConfigControlPlaneLog): ServiceMeshMeshConfigControlPlaneLog = ServiceMeshMeshConfigControlPlaneLog(
            enabled = javaType.enabled(),
            logTtlInDay = javaType.logTtlInDay().map({ args0 -> args0 }).orElse(null),
            project = javaType.project().map({ args0 -> args0 }).orElse(null),
        )
    }
}
