@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enabled Enable CNI.
 * @property limitCpu Sidecar injector Pods on the throttle.
 * @property limitMemory Sidecar injector Pods on the throttle.
 * @property logLevel OPA proxy container log level.
 * @property requestCpu Sidecar injector Pods on the requested resource.
 * @property requestMemory Sidecar injector Pods on the requested resource.
 */
public data class ServiceMeshMeshConfigOpa(
    public val enabled: Boolean? = null,
    public val limitCpu: String? = null,
    public val limitMemory: String? = null,
    public val logLevel: String? = null,
    public val requestCpu: String? = null,
    public val requestMemory: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicemesh.outputs.ServiceMeshMeshConfigOpa): ServiceMeshMeshConfigOpa = ServiceMeshMeshConfigOpa(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            limitCpu = javaType.limitCpu().map({ args0 -> args0 }).orElse(null),
            limitMemory = javaType.limitMemory().map({ args0 -> args0 }).orElse(null),
            logLevel = javaType.logLevel().map({ args0 -> args0 }).orElse(null),
            requestCpu = javaType.requestCpu().map({ args0 -> args0 }).orElse(null),
            requestMemory = javaType.requestMemory().map({ args0 -> args0 }).orElse(null),
        )
    }
}
