@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property externalUrl Prometheus service addresses (enabled external Prometheus when the system automatically populates).
 * @property useExternal Whether to enable external Prometheus.
 */
public data class ServiceMeshMeshConfigPrometheus(
    public val externalUrl: String? = null,
    public val useExternal: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicemesh.outputs.ServiceMeshMeshConfigPrometheus): ServiceMeshMeshConfigPrometheus = ServiceMeshMeshConfigPrometheus(
            externalUrl = javaType.externalUrl().map({ args0 -> args0 }).orElse(null),
            useExternal = javaType.useExternal().map({ args0 -> args0 }).orElse(null),
        )
    }
}
