@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property clusterDomain Cluster domain name.
 * @property limitCpu Sidecar injector Pods on the throttle.
 * @property limitMemory Sidecar injector Pods on the throttle.
 * @property requestCpu Sidecar injector Pods on the requested resource.
 * @property requestMemory Sidecar injector Pods on the requested resource.
 */
public data class ServiceMeshMeshConfigProxy(
    public val clusterDomain: String? = null,
    public val limitCpu: String? = null,
    public val limitMemory: String? = null,
    public val requestCpu: String? = null,
    public val requestMemory: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicemesh.outputs.ServiceMeshMeshConfigProxy): ServiceMeshMeshConfigProxy = ServiceMeshMeshConfigProxy(
            clusterDomain = javaType.clusterDomain().map({ args0 -> args0 }).orElse(null),
            limitCpu = javaType.limitCpu().map({ args0 -> args0 }).orElse(null),
            limitMemory = javaType.limitMemory().map({ args0 -> args0 }).orElse(null),
            requestCpu = javaType.requestCpu().map({ args0 -> args0 }).orElse(null),
            requestMemory = javaType.requestMemory().map({ args0 -> args0 }).orElse(null),
        )
    }
}
