@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property autoInjectionPolicyEnabled Whether to enable by Pod Annotations automatic injection Sidecar.
 * @property enableNamespacesByDefault Whether it is the all namespaces you turn on the auto injection capabilities.
 * @property initCniConfiguration CNI configuration. See `init_cni_configuration` below.
 * @property limitCpu Sidecar injector Pods on the throttle.
 * @property limitMemory Sidecar injector Pods on the throttle.
 * @property requestCpu Sidecar injector Pods on the requested resource.
 * @property requestMemory Sidecar injector Pods on the requested resource.
 * @property sidecarInjectorWebhookAsYaml Other automatic injection Sidecar configuration (in YAML format).
 */
public data class ServiceMeshMeshConfigSidecarInjector(
    public val autoInjectionPolicyEnabled: Boolean? = null,
    public val enableNamespacesByDefault: Boolean? = null,
    public val initCniConfiguration: ServiceMeshMeshConfigSidecarInjectorInitCniConfiguration? = null,
    public val limitCpu: String? = null,
    public val limitMemory: String? = null,
    public val requestCpu: String? = null,
    public val requestMemory: String? = null,
    public val sidecarInjectorWebhookAsYaml: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicemesh.outputs.ServiceMeshMeshConfigSidecarInjector): ServiceMeshMeshConfigSidecarInjector = ServiceMeshMeshConfigSidecarInjector(
            autoInjectionPolicyEnabled = javaType.autoInjectionPolicyEnabled().map({ args0 ->
                args0
            }).orElse(null),
            enableNamespacesByDefault = javaType.enableNamespacesByDefault().map({ args0 ->
                args0
            }).orElse(null),
            initCniConfiguration = javaType.initCniConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.servicemesh.kotlin.outputs.ServiceMeshMeshConfigSidecarInjectorInitCniConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            limitCpu = javaType.limitCpu().map({ args0 -> args0 }).orElse(null),
            limitMemory = javaType.limitMemory().map({ args0 -> args0 }).orElse(null),
            requestCpu = javaType.requestCpu().map({ args0 -> args0 }).orElse(null),
            requestMemory = javaType.requestMemory().map({ args0 -> args0 }).orElse(null),
            sidecarInjectorWebhookAsYaml = javaType.sidecarInjectorWebhookAsYaml().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
