@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property securityGroupId Security group ID.
 * @property vpcId VPC ID.
 * @property vswitcheList Virtual Switch ID.
 */
public data class ServiceMeshNetwork(
    public val securityGroupId: String? = null,
    public val vpcId: String,
    public val vswitcheList: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicemesh.outputs.ServiceMeshNetwork): ServiceMeshNetwork = ServiceMeshNetwork(
            securityGroupId = javaType.securityGroupId().map({ args0 -> args0 }).orElse(null),
            vpcId = javaType.vpcId(),
            vswitcheList = javaType.vswitcheList(),
        )
    }
}
