@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.servicemesh.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property isCustom Whether the grant object is a RAM role.
 * @property isRamRole Whether the grant object is an entity.
 * @property roleName The permission name. Valid values: `istio-admin`, `istio-ops`, `istio-readonly`.
 * - `istio-admin`:  The administrator.
 * - `istio-ops`: The administrator of the service mesh resource.
 * - `istio-readonly`: The read only permission.
 * @property roleType The role type. Valid Value: `custom`.
 * @property serviceMeshId The service mesh id.
 */
public data class UserPermissionPermission(
    public val isCustom: Boolean? = null,
    public val isRamRole: Boolean? = null,
    public val roleName: String? = null,
    public val roleType: String? = null,
    public val serviceMeshId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.servicemesh.outputs.UserPermissionPermission): UserPermissionPermission = UserPermissionPermission(
            isCustom = javaType.isCustom().map({ args0 -> args0 }).orElse(null),
            isRamRole = javaType.isRamRole().map({ args0 -> args0 }).orElse(null),
            roleName = javaType.roleName().map({ args0 -> args0 }).orElse(null),
            roleType = javaType.roleType().map({ args0 -> args0 }).orElse(null),
            serviceMeshId = javaType.serviceMeshId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
