@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.simpleapplicationserver.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [CustomImage].
 */
@PulumiTagMarker
public class CustomImageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomImageArgs = CustomImageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomImageArgsBuilder.() -> Unit) {
        val builder = CustomImageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CustomImage {
        val builtJavaResource =
            com.pulumi.alicloud.simpleapplicationserver.CustomImage(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CustomImage(builtJavaResource)
    }
}

/**
 * Provides a Simple Application Server Custom Image resource.
 * For information about Simple Application Server Custom Image and how to use it, see [What is Custom Image](https://www.alibabacloud.com/help/en/doc-detail/333535.htm).
 * > **NOTE:** Available since v1.143.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const default = alicloud.simpleapplicationserver.getImages({});
 * const defaultGetServerPlans = alicloud.simpleapplicationserver.getServerPlans({});
 * const defaultInstance = new alicloud.simpleapplicationserver.Instance("default", {
 *     paymentType: "Subscription",
 *     planId: defaultGetServerPlans.then(defaultGetServerPlans => defaultGetServerPlans.plans?.[0]?.id),
 *     instanceName: name,
 *     imageId: _default.then(_default => _default.images?.[0]?.id),
 *     period: 1,
 *     dataDiskSize: 100,
 * });
 * const defaultGetServerDisks = alicloud.simpleapplicationserver.getServerDisksOutput({
 *     instanceId: defaultInstance.id,
 * });
 * const defaultSnapshot = new alicloud.simpleapplicationserver.Snapshot("default", {
 *     diskId: defaultGetServerDisks.apply(defaultGetServerDisks => defaultGetServerDisks.ids?.[0]),
 *     snapshotName: name,
 * });
 * const defaultCustomImage = new alicloud.simpleapplicationserver.CustomImage("default", {
 *     customImageName: name,
 *     instanceId: defaultInstance.id,
 *     systemSnapshotId: defaultSnapshot.id,
 *     status: "Share",
 *     description: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.simpleapplicationserver.get_images()
 * default_get_server_plans = alicloud.simpleapplicationserver.get_server_plans()
 * default_instance = alicloud.simpleapplicationserver.Instance("default",
 *     payment_type="Subscription",
 *     plan_id=default_get_server_plans.plans[0].id,
 *     instance_name=name,
 *     image_id=default.images[0].id,
 *     period=1,
 *     data_disk_size=100)
 * default_get_server_disks = alicloud.simpleapplicationserver.get_server_disks_output(instance_id=default_instance.id)
 * default_snapshot = alicloud.simpleapplicationserver.Snapshot("default",
 *     disk_id=default_get_server_disks.ids[0],
 *     snapshot_name=name)
 * default_custom_image = alicloud.simpleapplicationserver.CustomImage("default",
 *     custom_image_name=name,
 *     instance_id=default_instance.id,
 *     system_snapshot_id=default_snapshot.id,
 *     status="Share",
 *     description=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = AliCloud.SimpleApplicationServer.GetImages.Invoke();
 *     var defaultGetServerPlans = AliCloud.SimpleApplicationServer.GetServerPlans.Invoke();
 *     var defaultInstance = new AliCloud.SimpleApplicationServer.Instance("default", new()
 *     {
 *         PaymentType = "Subscription",
 *         PlanId = defaultGetServerPlans.Apply(getServerPlansResult => getServerPlansResult.Plans[0]?.Id),
 *         InstanceName = name,
 *         ImageId = @default.Apply(@default => @default.Apply(getImagesResult => getImagesResult.Images[0]?.Id)),
 *         Period = 1,
 *         DataDiskSize = 100,
 *     });
 *     var defaultGetServerDisks = AliCloud.SimpleApplicationServer.GetServerDisks.Invoke(new()
 *     {
 *         InstanceId = defaultInstance.Id,
 *     });
 *     var defaultSnapshot = new AliCloud.SimpleApplicationServer.Snapshot("default", new()
 *     {
 *         DiskId = defaultGetServerDisks.Apply(getServerDisksResult => getServerDisksResult.Ids[0]),
 *         SnapshotName = name,
 *     });
 *     var defaultCustomImage = new AliCloud.SimpleApplicationServer.CustomImage("default", new()
 *     {
 *         CustomImageName = name,
 *         InstanceId = defaultInstance.Id,
 *         SystemSnapshotId = defaultSnapshot.Id,
 *         Status = "Share",
 *         Description = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/simpleapplicationserver"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := simpleapplicationserver.GetImages(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetServerPlans, err := simpleapplicationserver.GetServerPlans(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := simpleapplicationserver.NewInstance(ctx, "default", &simpleapplicationserver.InstanceArgs{
 * 			PaymentType:  pulumi.String("Subscription"),
 * 			PlanId:       pulumi.String(defaultGetServerPlans.Plans[0].Id),
 * 			InstanceName: pulumi.String(name),
 * 			ImageId:      pulumi.String(_default.Images[0].Id),
 * 			Period:       pulumi.Int(1),
 * 			DataDiskSize: pulumi.Int(100),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetServerDisks := simpleapplicationserver.GetServerDisksOutput(ctx, simpleapplicationserver.GetServerDisksOutputArgs{
 * 			InstanceId: defaultInstance.ID(),
 * 		}, nil)
 * 		defaultSnapshot, err := simpleapplicationserver.NewSnapshot(ctx, "default", &simpleapplicationserver.SnapshotArgs{
 * 			DiskId: pulumi.String(defaultGetServerDisks.ApplyT(func(defaultGetServerDisks simpleapplicationserver.GetServerDisksResult) (*string, error) {
 * 				return &defaultGetServerDisks.Ids[0], nil
 * 			}).(pulumi.StringPtrOutput)),
 * 			SnapshotName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = simpleapplicationserver.NewCustomImage(ctx, "default", &simpleapplicationserver.CustomImageArgs{
 * 			CustomImageName:  pulumi.String(name),
 * 			InstanceId:       defaultInstance.ID(),
 * 			SystemSnapshotId: defaultSnapshot.ID(),
 * 			Status:           pulumi.String("Share"),
 * 			Description:      pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.simpleapplicationserver.SimpleapplicationserverFunctions;
 * import com.pulumi.alicloud.simpleapplicationserver.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.simpleapplicationserver.inputs.GetServerPlansArgs;
 * import com.pulumi.alicloud.simpleapplicationserver.Instance;
 * import com.pulumi.alicloud.simpleapplicationserver.InstanceArgs;
 * import com.pulumi.alicloud.simpleapplicationserver.inputs.GetServerDisksArgs;
 * import com.pulumi.alicloud.simpleapplicationserver.Snapshot;
 * import com.pulumi.alicloud.simpleapplicationserver.SnapshotArgs;
 * import com.pulumi.alicloud.simpleapplicationserver.CustomImage;
 * import com.pulumi.alicloud.simpleapplicationserver.CustomImageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         final var default = SimpleapplicationserverFunctions.getImages();
 *         final var defaultGetServerPlans = SimpleapplicationserverFunctions.getServerPlans();
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .paymentType("Subscription")
 *             .planId(defaultGetServerPlans.applyValue(getServerPlansResult -> getServerPlansResult.plans()[0].id()))
 *             .instanceName(name)
 *             .imageId(default_.images()[0].id())
 *             .period(1)
 *             .dataDiskSize(100)
 *             .build());
 *         final var defaultGetServerDisks = SimpleapplicationserverFunctions.getServerDisks(GetServerDisksArgs.builder()
 *             .instanceId(defaultInstance.id())
 *             .build());
 *         var defaultSnapshot = new Snapshot("defaultSnapshot", SnapshotArgs.builder()
 *             .diskId(defaultGetServerDisks.applyValue(getServerDisksResult -> getServerDisksResult).applyValue(defaultGetServerDisks -> defaultGetServerDisks.applyValue(getServerDisksResult -> getServerDisksResult.ids()[0])))
 *             .snapshotName(name)
 *             .build());
 *         var defaultCustomImage = new CustomImage("defaultCustomImage", CustomImageArgs.builder()
 *             .customImageName(name)
 *             .instanceId(defaultInstance.id())
 *             .systemSnapshotId(defaultSnapshot.id())
 *             .status("Share")
 *             .description(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   defaultInstance:
 *     type: alicloud:simpleapplicationserver:Instance
 *     name: default
 *     properties:
 *       paymentType: Subscription
 *       planId: ${defaultGetServerPlans.plans[0].id}
 *       instanceName: ${name}
 *       imageId: ${default.images[0].id}
 *       period: 1
 *       dataDiskSize: 100
 *   defaultSnapshot:
 *     type: alicloud:simpleapplicationserver:Snapshot
 *     name: default
 *     properties:
 *       diskId: ${defaultGetServerDisks.ids[0]}
 *       snapshotName: ${name}
 *   defaultCustomImage:
 *     type: alicloud:simpleapplicationserver:CustomImage
 *     name: default
 *     properties:
 *       customImageName: ${name}
 *       instanceId: ${defaultInstance.id}
 *       systemSnapshotId: ${defaultSnapshot.id}
 *       status: Share
 *       description: ${name}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:simpleapplicationserver:getImages
 *       Arguments: {}
 *   defaultGetServerPlans:
 *     fn::invoke:
 *       Function: alicloud:simpleapplicationserver:getServerPlans
 *       Arguments: {}
 *   defaultGetServerDisks:
 *     fn::invoke:
 *       Function: alicloud:simpleapplicationserver:getServerDisks
 *       Arguments:
 *         instanceId: ${defaultInstance.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Simple Application Server Custom Image can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:simpleapplicationserver/customImage:CustomImage example <id>
 * ```
 */
public class CustomImage internal constructor(
    override val javaResource: com.pulumi.alicloud.simpleapplicationserver.CustomImage,
) : KotlinCustomResource(javaResource, CustomImageMapper) {
    /**
     * The name of the resource. The name must be `2` to `128` characters in length. It must start with a letter or a number. It can contain letters, digits, colons (:), underscores (_) and hyphens (-).
     */
    public val customImageName: Output<String>
        get() = javaResource.customImageName().applyValue({ args0 -> args0 })

    /**
     * The description of the Custom Image.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The Shared status of the Custom Image. Valid values: `Share`, `UnShare`.
     * **NOTE:** The `status` will be automatically change to `UnShare` when the resource is deleted, please operate with caution.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the system snapshot.
     */
    public val systemSnapshotId: Output<String>
        get() = javaResource.systemSnapshotId().applyValue({ args0 -> args0 })
}

public object CustomImageMapper : ResourceMapper<CustomImage> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.simpleapplicationserver.CustomImage::class == javaResource::class

    override fun map(javaResource: Resource): CustomImage = CustomImage(
        javaResource as
            com.pulumi.alicloud.simpleapplicationserver.CustomImage,
    )
}

/**
 * @see [CustomImage].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomImage].
 */
public suspend fun customImage(name: String, block: suspend CustomImageResourceBuilder.() -> Unit): CustomImage {
    val builder = CustomImageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomImage].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customImage(name: String): CustomImage {
    val builder = CustomImageResourceBuilder()
    builder.name(name)
    return builder.build()
}
