@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.simpleapplicationserver.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [FirewallRule].
 */
@PulumiTagMarker
public class FirewallRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FirewallRuleArgs = FirewallRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FirewallRuleArgsBuilder.() -> Unit) {
        val builder = FirewallRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FirewallRule {
        val builtJavaResource =
            com.pulumi.alicloud.simpleapplicationserver.FirewallRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return FirewallRule(builtJavaResource)
    }
}

/**
 * Provides a Simple Application Server Firewall Rule resource.
 * For information about Simple Application Server Firewall Rule and how to use it, see [What is Firewall Rule](https://www.alibabacloud.com/help/doc-detail/190449.htm).
 * > **NOTE:** Available since v1.143.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const default = alicloud.simpleapplicationserver.getImages({});
 * const defaultGetServerPlans = alicloud.simpleapplicationserver.getServerPlans({});
 * const defaultInstance = new alicloud.simpleapplicationserver.Instance("default", {
 *     paymentType: "Subscription",
 *     planId: defaultGetServerPlans.then(defaultGetServerPlans => defaultGetServerPlans.plans?.[0]?.id),
 *     instanceName: name,
 *     imageId: _default.then(_default => _default.images?.[0]?.id),
 *     period: 1,
 *     dataDiskSize: 100,
 * });
 * const defaultFirewallRule = new alicloud.simpleapplicationserver.FirewallRule("default", {
 *     instanceId: defaultInstance.id,
 *     ruleProtocol: "Tcp",
 *     port: "9999",
 *     remark: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.simpleapplicationserver.get_images()
 * default_get_server_plans = alicloud.simpleapplicationserver.get_server_plans()
 * default_instance = alicloud.simpleapplicationserver.Instance("default",
 *     payment_type="Subscription",
 *     plan_id=default_get_server_plans.plans[0].id,
 *     instance_name=name,
 *     image_id=default.images[0].id,
 *     period=1,
 *     data_disk_size=100)
 * default_firewall_rule = alicloud.simpleapplicationserver.FirewallRule("default",
 *     instance_id=default_instance.id,
 *     rule_protocol="Tcp",
 *     port="9999",
 *     remark=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = AliCloud.SimpleApplicationServer.GetImages.Invoke();
 *     var defaultGetServerPlans = AliCloud.SimpleApplicationServer.GetServerPlans.Invoke();
 *     var defaultInstance = new AliCloud.SimpleApplicationServer.Instance("default", new()
 *     {
 *         PaymentType = "Subscription",
 *         PlanId = defaultGetServerPlans.Apply(getServerPlansResult => getServerPlansResult.Plans[0]?.Id),
 *         InstanceName = name,
 *         ImageId = @default.Apply(@default => @default.Apply(getImagesResult => getImagesResult.Images[0]?.Id)),
 *         Period = 1,
 *         DataDiskSize = 100,
 *     });
 *     var defaultFirewallRule = new AliCloud.SimpleApplicationServer.FirewallRule("default", new()
 *     {
 *         InstanceId = defaultInstance.Id,
 *         RuleProtocol = "Tcp",
 *         Port = "9999",
 *         Remark = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/simpleapplicationserver"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := simpleapplicationserver.GetImages(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetServerPlans, err := simpleapplicationserver.GetServerPlans(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := simpleapplicationserver.NewInstance(ctx, "default", &simpleapplicationserver.InstanceArgs{
 * 			PaymentType:  pulumi.String("Subscription"),
 * 			PlanId:       pulumi.String(defaultGetServerPlans.Plans[0].Id),
 * 			InstanceName: pulumi.String(name),
 * 			ImageId:      pulumi.String(_default.Images[0].Id),
 * 			Period:       pulumi.Int(1),
 * 			DataDiskSize: pulumi.Int(100),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = simpleapplicationserver.NewFirewallRule(ctx, "default", &simpleapplicationserver.FirewallRuleArgs{
 * 			InstanceId:   defaultInstance.ID(),
 * 			RuleProtocol: pulumi.String("Tcp"),
 * 			Port:         pulumi.String("9999"),
 * 			Remark:       pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.simpleapplicationserver.SimpleapplicationserverFunctions;
 * import com.pulumi.alicloud.simpleapplicationserver.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.simpleapplicationserver.inputs.GetServerPlansArgs;
 * import com.pulumi.alicloud.simpleapplicationserver.Instance;
 * import com.pulumi.alicloud.simpleapplicationserver.InstanceArgs;
 * import com.pulumi.alicloud.simpleapplicationserver.FirewallRule;
 * import com.pulumi.alicloud.simpleapplicationserver.FirewallRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         final var default = SimpleapplicationserverFunctions.getImages();
 *         final var defaultGetServerPlans = SimpleapplicationserverFunctions.getServerPlans();
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .paymentType("Subscription")
 *             .planId(defaultGetServerPlans.applyValue(getServerPlansResult -> getServerPlansResult.plans()[0].id()))
 *             .instanceName(name)
 *             .imageId(default_.images()[0].id())
 *             .period(1)
 *             .dataDiskSize(100)
 *             .build());
 *         var defaultFirewallRule = new FirewallRule("defaultFirewallRule", FirewallRuleArgs.builder()
 *             .instanceId(defaultInstance.id())
 *             .ruleProtocol("Tcp")
 *             .port("9999")
 *             .remark(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   defaultInstance:
 *     type: alicloud:simpleapplicationserver:Instance
 *     name: default
 *     properties:
 *       paymentType: Subscription
 *       planId: ${defaultGetServerPlans.plans[0].id}
 *       instanceName: ${name}
 *       imageId: ${default.images[0].id}
 *       period: 1
 *       dataDiskSize: 100
 *   defaultFirewallRule:
 *     type: alicloud:simpleapplicationserver:FirewallRule
 *     name: default
 *     properties:
 *       instanceId: ${defaultInstance.id}
 *       ruleProtocol: Tcp
 *       port: '9999'
 *       remark: ${name}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:simpleapplicationserver:getImages
 *       Arguments: {}
 *   defaultGetServerPlans:
 *     fn::invoke:
 *       Function: alicloud:simpleapplicationserver:getServerPlans
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Simple Application Server Firewall Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:simpleapplicationserver/firewallRule:FirewallRule example <instance_id>:<firewall_rule_id>
 * ```
 */
public class FirewallRule internal constructor(
    override val javaResource: com.pulumi.alicloud.simpleapplicationserver.FirewallRule,
) : KotlinCustomResource(javaResource, FirewallRuleMapper) {
    /**
     * The ID of the firewall rule.
     */
    public val firewallRuleId: Output<String>
        get() = javaResource.firewallRuleId().applyValue({ args0 -> args0 })

    /**
     * Alibaba Cloud simple application server instance ID.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The port range. Valid values of port numbers: `1` to `65535`. Specify a port range in the format of `<start port number>/<end port number>`. Example: `1024/1055`, which indicates the port range of `1024` through `1055`.
     */
    public val port: Output<String>
        get() = javaResource.port().applyValue({ args0 -> args0 })

    /**
     * The remarks of the firewall rule.
     */
    public val remark: Output<String>?
        get() = javaResource.remark().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The transport layer protocol. Valid values: `Tcp`, `Udp`, `TcpAndUdp`.
     */
    public val ruleProtocol: Output<String>
        get() = javaResource.ruleProtocol().applyValue({ args0 -> args0 })
}

public object FirewallRuleMapper : ResourceMapper<FirewallRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.simpleapplicationserver.FirewallRule::class == javaResource::class

    override fun map(javaResource: Resource): FirewallRule = FirewallRule(
        javaResource as
            com.pulumi.alicloud.simpleapplicationserver.FirewallRule,
    )
}

/**
 * @see [FirewallRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FirewallRule].
 */
public suspend fun firewallRule(
    name: String,
    block: suspend FirewallRuleResourceBuilder.() -> Unit,
): FirewallRule {
    val builder = FirewallRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FirewallRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun firewallRule(name: String): FirewallRule {
    val builder = FirewallRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
