@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.simpleapplicationserver.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource =
            com.pulumi.alicloud.simpleapplicationserver.Instance(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Instance(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * Simple Application Server Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:simpleapplicationserver/instance:Instance example <id>
 * ```
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.alicloud.simpleapplicationserver.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * Specifies whether to enable auto-renewal. Unit: months. Valid values: `true` and `false`.
     */
    public val autoRenew: Output<Boolean>?
        get() = javaResource.autoRenew().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The auto renew period. Valid values: `1`,`3`, `6`, `12`, `24`, `36`. **NOTE:** The attribute `auto_renew` is valid when the attribute is `true`.
     */
    public val autoRenewPeriod: Output<Int>?
        get() = javaResource.autoRenewPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The size of the data disk. Unit: GB. Valid values: `0` to `16380`.
     */
    public val dataDiskSize: Output<Int>?
        get() = javaResource.dataDiskSize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the image.  You can use the `alicloud.simpleapplicationserver.getImages` to query the available images in the specified region. The value must be an integral multiple of 20.
     */
    public val imageId: Output<String>
        get() = javaResource.imageId().applyValue({ args0 -> args0 })

    /**
     * The name of the simple application server.
     */
    public val instanceName: Output<String>?
        get() = javaResource.instanceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The password of the simple application server. The password must be 8 to 30 characters in length. It must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include: `( ) ~ ! @ # $ % ^ & * - + = | { } [ ] : ; < > , . ? /`.
     */
    public val password: Output<String>?
        get() = javaResource.password().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The paymen type of the resource. Valid values: `Subscription`.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * The period. Unit: months. Valid values: `1`,`3`, `6`, `12`, `24`, `36`.
     */
    public val period: Output<Int>
        get() = javaResource.period().applyValue({ args0 -> args0 })

    /**
     * The ID of the plan. You can use the `alicloud.simpleapplicationserver.getServerPlans`  to query all the plans provided by Simple Application Server in the specified region.
     */
    public val planId: Output<String>
        get() = javaResource.planId().applyValue({ args0 -> args0 })

    /**
     * The status of the simple application server. Valid values: `Resetting`, `Running`, `Stopped`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.simpleapplicationserver.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.alicloud.simpleapplicationserver.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
