@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.simpleapplicationserver.kotlin

import com.pulumi.alicloud.simpleapplicationserver.InstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * Simple Application Server Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:simpleapplicationserver/instance:Instance example <id>
 * ```
 * @property autoRenew Specifies whether to enable auto-renewal. Unit: months. Valid values: `true` and `false`.
 * @property autoRenewPeriod The auto renew period. Valid values: `1`,`3`, `6`, `12`, `24`, `36`. **NOTE:** The attribute `auto_renew` is valid when the attribute is `true`.
 * @property dataDiskSize The size of the data disk. Unit: GB. Valid values: `0` to `16380`.
 * @property imageId The ID of the image.  You can use the `alicloud.simpleapplicationserver.getImages` to query the available images in the specified region. The value must be an integral multiple of 20.
 * @property instanceName The name of the simple application server.
 * @property password The password of the simple application server. The password must be 8 to 30 characters in length. It must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include: `( ) ~ ! @ # $ % ^ & * - + = | { } [ ] : ; < > , . ? /`.
 * @property paymentType The paymen type of the resource. Valid values: `Subscription`.
 * @property period The period. Unit: months. Valid values: `1`,`3`, `6`, `12`, `24`, `36`.
 * @property planId The ID of the plan. You can use the `alicloud.simpleapplicationserver.getServerPlans`  to query all the plans provided by Simple Application Server in the specified region.
 * @property status The status of the simple application server. Valid values: `Resetting`, `Running`, `Stopped`.
 */
public data class InstanceArgs(
    public val autoRenew: Output<Boolean>? = null,
    public val autoRenewPeriod: Output<Int>? = null,
    public val dataDiskSize: Output<Int>? = null,
    public val imageId: Output<String>? = null,
    public val instanceName: Output<String>? = null,
    public val password: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val planId: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.simpleapplicationserver.InstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.simpleapplicationserver.InstanceArgs =
        com.pulumi.alicloud.simpleapplicationserver.InstanceArgs.builder()
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .autoRenewPeriod(autoRenewPeriod?.applyValue({ args0 -> args0 }))
            .dataDiskSize(dataDiskSize?.applyValue({ args0 -> args0 }))
            .imageId(imageId?.applyValue({ args0 -> args0 }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .planId(planId?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var autoRenew: Output<Boolean>? = null

    private var autoRenewPeriod: Output<Int>? = null

    private var dataDiskSize: Output<Int>? = null

    private var imageId: Output<String>? = null

    private var instanceName: Output<String>? = null

    private var password: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<Int>? = null

    private var planId: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value Specifies whether to enable auto-renewal. Unit: months. Valid values: `true` and `false`.
     */
    @JvmName("ckgnvoagjfgruamr")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value The auto renew period. Valid values: `1`,`3`, `6`, `12`, `24`, `36`. **NOTE:** The attribute `auto_renew` is valid when the attribute is `true`.
     */
    @JvmName("tkvotwnasxeghcey")
    public suspend fun autoRenewPeriod(`value`: Output<Int>) {
        this.autoRenewPeriod = value
    }

    /**
     * @param value The size of the data disk. Unit: GB. Valid values: `0` to `16380`.
     */
    @JvmName("ihpfolfwrwxosaft")
    public suspend fun dataDiskSize(`value`: Output<Int>) {
        this.dataDiskSize = value
    }

    /**
     * @param value The ID of the image.  You can use the `alicloud.simpleapplicationserver.getImages` to query the available images in the specified region. The value must be an integral multiple of 20.
     */
    @JvmName("smufukbgcfqfevxo")
    public suspend fun imageId(`value`: Output<String>) {
        this.imageId = value
    }

    /**
     * @param value The name of the simple application server.
     */
    @JvmName("lbyugqwmrcvnaxpw")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value The password of the simple application server. The password must be 8 to 30 characters in length. It must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include: `( ) ~ ! @ # $ % ^ & * - + = | { } [ ] : ; < > , . ? /`.
     */
    @JvmName("ikbbokusbhpysfxw")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The paymen type of the resource. Valid values: `Subscription`.
     */
    @JvmName("luhqwrunyfewdbwo")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The period. Unit: months. Valid values: `1`,`3`, `6`, `12`, `24`, `36`.
     */
    @JvmName("mgogibsiopsfgvkh")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The ID of the plan. You can use the `alicloud.simpleapplicationserver.getServerPlans`  to query all the plans provided by Simple Application Server in the specified region.
     */
    @JvmName("andtvrvxbyyfjjiq")
    public suspend fun planId(`value`: Output<String>) {
        this.planId = value
    }

    /**
     * @param value The status of the simple application server. Valid values: `Resetting`, `Running`, `Stopped`.
     */
    @JvmName("sldjhtqprpvvmjso")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Specifies whether to enable auto-renewal. Unit: months. Valid values: `true` and `false`.
     */
    @JvmName("ojiwjsdtapkvsxho")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value The auto renew period. Valid values: `1`,`3`, `6`, `12`, `24`, `36`. **NOTE:** The attribute `auto_renew` is valid when the attribute is `true`.
     */
    @JvmName("mvnfengxjkuujkdf")
    public suspend fun autoRenewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenewPeriod = mapped
    }

    /**
     * @param value The size of the data disk. Unit: GB. Valid values: `0` to `16380`.
     */
    @JvmName("fglwpkmlcagllmor")
    public suspend fun dataDiskSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDiskSize = mapped
    }

    /**
     * @param value The ID of the image.  You can use the `alicloud.simpleapplicationserver.getImages` to query the available images in the specified region. The value must be an integral multiple of 20.
     */
    @JvmName("uctrjsorgfdywrny")
    public suspend fun imageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageId = mapped
    }

    /**
     * @param value The name of the simple application server.
     */
    @JvmName("ruanfwutvqgoukcx")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value The password of the simple application server. The password must be 8 to 30 characters in length. It must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include: `( ) ~ ! @ # $ % ^ & * - + = | { } [ ] : ; < > , . ? /`.
     */
    @JvmName("hdipeoxmvjqllesc")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The paymen type of the resource. Valid values: `Subscription`.
     */
    @JvmName("dherbagtoshaleny")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The period. Unit: months. Valid values: `1`,`3`, `6`, `12`, `24`, `36`.
     */
    @JvmName("aiirsguunojvtwko")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The ID of the plan. You can use the `alicloud.simpleapplicationserver.getServerPlans`  to query all the plans provided by Simple Application Server in the specified region.
     */
    @JvmName("xmeoihnldvfvjxqo")
    public suspend fun planId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.planId = mapped
    }

    /**
     * @param value The status of the simple application server. Valid values: `Resetting`, `Running`, `Stopped`.
     */
    @JvmName("gcsiwulhtgglhpkn")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        autoRenew = autoRenew,
        autoRenewPeriod = autoRenewPeriod,
        dataDiskSize = dataDiskSize,
        imageId = imageId,
        instanceName = instanceName,
        password = password,
        paymentType = paymentType,
        period = period,
        planId = planId,
        status = status,
    )
}
