@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.simpleapplicationserver.kotlin

import com.pulumi.alicloud.simpleapplicationserver.SimpleapplicationserverFunctions.getImagesPlain
import com.pulumi.alicloud.simpleapplicationserver.SimpleapplicationserverFunctions.getInstancesPlain
import com.pulumi.alicloud.simpleapplicationserver.SimpleapplicationserverFunctions.getServerCustomImagesPlain
import com.pulumi.alicloud.simpleapplicationserver.SimpleapplicationserverFunctions.getServerDisksPlain
import com.pulumi.alicloud.simpleapplicationserver.SimpleapplicationserverFunctions.getServerFirewallRulesPlain
import com.pulumi.alicloud.simpleapplicationserver.SimpleapplicationserverFunctions.getServerPlansPlain
import com.pulumi.alicloud.simpleapplicationserver.SimpleapplicationserverFunctions.getServerSnapshotsPlain
import com.pulumi.alicloud.simpleapplicationserver.kotlin.inputs.GetImagesPlainArgs
import com.pulumi.alicloud.simpleapplicationserver.kotlin.inputs.GetImagesPlainArgsBuilder
import com.pulumi.alicloud.simpleapplicationserver.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.alicloud.simpleapplicationserver.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.alicloud.simpleapplicationserver.kotlin.inputs.GetServerCustomImagesPlainArgs
import com.pulumi.alicloud.simpleapplicationserver.kotlin.inputs.GetServerCustomImagesPlainArgsBuilder
import com.pulumi.alicloud.simpleapplicationserver.kotlin.inputs.GetServerDisksPlainArgs
import com.pulumi.alicloud.simpleapplicationserver.kotlin.inputs.GetServerDisksPlainArgsBuilder
import com.pulumi.alicloud.simpleapplicationserver.kotlin.inputs.GetServerFirewallRulesPlainArgs
import com.pulumi.alicloud.simpleapplicationserver.kotlin.inputs.GetServerFirewallRulesPlainArgsBuilder
import com.pulumi.alicloud.simpleapplicationserver.kotlin.inputs.GetServerPlansPlainArgs
import com.pulumi.alicloud.simpleapplicationserver.kotlin.inputs.GetServerPlansPlainArgsBuilder
import com.pulumi.alicloud.simpleapplicationserver.kotlin.inputs.GetServerSnapshotsPlainArgs
import com.pulumi.alicloud.simpleapplicationserver.kotlin.inputs.GetServerSnapshotsPlainArgsBuilder
import com.pulumi.alicloud.simpleapplicationserver.kotlin.outputs.GetImagesResult
import com.pulumi.alicloud.simpleapplicationserver.kotlin.outputs.GetInstancesResult
import com.pulumi.alicloud.simpleapplicationserver.kotlin.outputs.GetServerCustomImagesResult
import com.pulumi.alicloud.simpleapplicationserver.kotlin.outputs.GetServerDisksResult
import com.pulumi.alicloud.simpleapplicationserver.kotlin.outputs.GetServerFirewallRulesResult
import com.pulumi.alicloud.simpleapplicationserver.kotlin.outputs.GetServerPlansResult
import com.pulumi.alicloud.simpleapplicationserver.kotlin.outputs.GetServerSnapshotsResult
import kotlinx.coroutines.future.await
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.simpleapplicationserver.kotlin.outputs.GetImagesResult.Companion.toKotlin as getImagesResultToKotlin
import com.pulumi.alicloud.simpleapplicationserver.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.alicloud.simpleapplicationserver.kotlin.outputs.GetServerCustomImagesResult.Companion.toKotlin as getServerCustomImagesResultToKotlin
import com.pulumi.alicloud.simpleapplicationserver.kotlin.outputs.GetServerDisksResult.Companion.toKotlin as getServerDisksResultToKotlin
import com.pulumi.alicloud.simpleapplicationserver.kotlin.outputs.GetServerFirewallRulesResult.Companion.toKotlin as getServerFirewallRulesResultToKotlin
import com.pulumi.alicloud.simpleapplicationserver.kotlin.outputs.GetServerPlansResult.Companion.toKotlin as getServerPlansResultToKotlin
import com.pulumi.alicloud.simpleapplicationserver.kotlin.outputs.GetServerSnapshotsResult.Companion.toKotlin as getServerSnapshotsResultToKotlin

public object SimpleapplicationserverFunctions {
    /**
     * This data source provides the Simple Application Server Images of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.135.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.simpleapplicationserver.SimpleapplicationserverFunctions;
     * import com.pulumi.alicloud.simpleapplicationserver.inputs.GetImagesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var instanceImageType = SimpleapplicationserverFunctions.getImages(GetImagesArgs.builder()
     *             .instanceImageType("system")
     *             .build());
     *         ctx.export("simpleApplicationServerImageId1", ids.images()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   instanceImageType:
     *     fn::invoke:
     *       Function: alicloud:simpleapplicationserver:getImages
     *       Arguments:
     *         instanceImageType: system
     * outputs:
     *   simpleApplicationServerImageId1: ${ids.images[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * The following arguments are supported:
     * * `ids` - (Optional, ForceNew, Computed)  A list of Image IDs.
     * * `image_type` - (Optional, ForceNew) The image type. Valid values: `app`, `custom`, `system`.
     * * `name_regex` - (Optional, ForceNew) A regex string to filter results by Image name.
     * * `platform` - (Available in v1.161.0) The platform of Image supported. Valid values: ["Linux", "Windows"].
     * * `output_file` - (Optional) File name where to save data source results (after running `pulumi preview`).
     * @param argument A collection of arguments for invoking getImages.
     * @return A collection of values returned by getImages.
     */
    public suspend fun getImages(argument: GetImagesPlainArgs): GetImagesResult =
        getImagesResultToKotlin(getImagesPlain(argument.toJava()).await())

    /**
     * @see [getImages].
     * @param ids
     * @param imageType
     * @param nameRegex
     * @param outputFile
     * @param platform
     * @return A collection of values returned by getImages.
     */
    public suspend fun getImages(
        ids: List<String>? = null,
        imageType: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        platform: String? = null,
    ): GetImagesResult {
        val argument = GetImagesPlainArgs(
            ids = ids,
            imageType = imageType,
            nameRegex = nameRegex,
            outputFile = outputFile,
            platform = platform,
        )
        return getImagesResultToKotlin(getImagesPlain(argument.toJava()).await())
    }

    /**
     * @see [getImages].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;simpleapplicationserver&#46;kotlin&#46;inputs&#46;GetImagesPlainArgs].
     * @return A collection of values returned by getImages.
     */
    public suspend fun getImages(argument: suspend GetImagesPlainArgsBuilder.() -> Unit): GetImagesResult {
        val builder = GetImagesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getImagesResultToKotlin(getImagesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Simple Application Server Instances of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.135.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.simpleapplicationserver.getInstances({
     *     ids: ["example_id"],
     * });
     * export const simpleApplicationServerInstanceId1 = ids.then(ids => ids.instances?.[0]?.id);
     * const nameRegex = alicloud.simpleapplicationserver.getInstances({
     *     nameRegex: "^my-Instance",
     * });
     * export const simpleApplicationServerInstanceId2 = nameRegex.then(nameRegex => nameRegex.instances?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.simpleapplicationserver.get_instances(ids=["example_id"])
     * pulumi.export("simpleApplicationServerInstanceId1", ids.instances[0].id)
     * name_regex = alicloud.simpleapplicationserver.get_instances(name_regex="^my-Instance")
     * pulumi.export("simpleApplicationServerInstanceId2", name_regex.instances[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.SimpleApplicationServer.GetInstances.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.SimpleApplicationServer.GetInstances.Invoke(new()
     *     {
     *         NameRegex = "^my-Instance",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["simpleApplicationServerInstanceId1"] = ids&#46;Apply(getInstancesResult => getInstancesResult&#46;Instances[0]?.Id),
     *         ["simpleApplicationServerInstanceId2"] = nameRegex&#46;Apply(getInstancesResult => getInstancesResult&#46;Instances[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/simpleapplicationserver"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := simpleapplicationserver.GetInstances(ctx, &simpleapplicationserver.GetInstancesArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("simpleApplicationServerInstanceId1", ids.Instances[0].Id)
     * 		nameRegex, err := simpleapplicationserver.GetInstances(ctx, &simpleapplicationserver.GetInstancesArgs{
     * 			NameRegex: pulumi.StringRef("^my-Instance"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("simpleApplicationServerInstanceId2", nameRegex.Instances[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.simpleapplicationserver.SimpleapplicationserverFunctions;
     * import com.pulumi.alicloud.simpleapplicationserver.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = SimpleapplicationserverFunctions.getInstances(GetInstancesArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("simpleApplicationServerInstanceId1", ids.applyValue(getInstancesResult -> getInstancesResult.instances()[0].id()));
     *         final var nameRegex = SimpleapplicationserverFunctions.getInstances(GetInstancesArgs.builder()
     *             .nameRegex("^my-Instance")
     *             .build());
     *         ctx.export("simpleApplicationServerInstanceId2", nameRegex.applyValue(getInstancesResult -> getInstancesResult.instances()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:simpleapplicationserver:getInstances
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:simpleapplicationserver:getInstances
     *       Arguments:
     *         nameRegex: ^my-Instance
     * outputs:
     *   simpleApplicationServerInstanceId1: ${ids.instances[0].id}
     *   simpleApplicationServerInstanceId2: ${nameRegex.instances[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param ids A list of Instance IDs.
     * @param nameRegex A regex string to filter results by Instance name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param paymentType The paymen type of the resource. Valid values: `Subscription`.
     * @param status The status of the resource. Valid values: `Resetting`, `Running`, `Stopped`, `Upgrading`.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        paymentType: String? = null,
        status: String? = null,
    ): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            paymentType = paymentType,
            status = status,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;simpleapplicationserver&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Simple Application Server Custom Images of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.143.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.simpleapplicationserver.getServerCustomImages({
     *     ids: ["example_id"],
     * });
     * export const simpleApplicationServerCustomImageId1 = ids.then(ids => ids.images?.[0]?.id);
     * const nameRegex = alicloud.simpleapplicationserver.getServerCustomImages({
     *     nameRegex: "^my-CustomImage",
     * });
     * export const simpleApplicationServerCustomImageId2 = nameRegex.then(nameRegex => nameRegex.images?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.simpleapplicationserver.get_server_custom_images(ids=["example_id"])
     * pulumi.export("simpleApplicationServerCustomImageId1", ids.images[0].id)
     * name_regex = alicloud.simpleapplicationserver.get_server_custom_images(name_regex="^my-CustomImage")
     * pulumi.export("simpleApplicationServerCustomImageId2", name_regex.images[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.SimpleApplicationServer.GetServerCustomImages.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.SimpleApplicationServer.GetServerCustomImages.Invoke(new()
     *     {
     *         NameRegex = "^my-CustomImage",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["simpleApplicationServerCustomImageId1"] = ids&#46;Apply(getServerCustomImagesResult => getServerCustomImagesResult&#46;Images[0]?.Id),
     *         ["simpleApplicationServerCustomImageId2"] = nameRegex&#46;Apply(getServerCustomImagesResult => getServerCustomImagesResult&#46;Images[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/simpleapplicationserver"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := simpleapplicationserver.GetServerCustomImages(ctx, &simpleapplicationserver.GetServerCustomImagesArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("simpleApplicationServerCustomImageId1", ids.Images[0].Id)
     * 		nameRegex, err := simpleapplicationserver.GetServerCustomImages(ctx, &simpleapplicationserver.GetServerCustomImagesArgs{
     * 			NameRegex: pulumi.StringRef("^my-CustomImage"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("simpleApplicationServerCustomImageId2", nameRegex.Images[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.simpleapplicationserver.SimpleapplicationserverFunctions;
     * import com.pulumi.alicloud.simpleapplicationserver.inputs.GetServerCustomImagesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = SimpleapplicationserverFunctions.getServerCustomImages(GetServerCustomImagesArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("simpleApplicationServerCustomImageId1", ids.applyValue(getServerCustomImagesResult -> getServerCustomImagesResult.images()[0].id()));
     *         final var nameRegex = SimpleapplicationserverFunctions.getServerCustomImages(GetServerCustomImagesArgs.builder()
     *             .nameRegex("^my-CustomImage")
     *             .build());
     *         ctx.export("simpleApplicationServerCustomImageId2", nameRegex.applyValue(getServerCustomImagesResult -> getServerCustomImagesResult.images()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:simpleapplicationserver:getServerCustomImages
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:simpleapplicationserver:getServerCustomImages
     *       Arguments:
     *         nameRegex: ^my-CustomImage
     * outputs:
     *   simpleApplicationServerCustomImageId1: ${ids.images[0].id}
     *   simpleApplicationServerCustomImageId2: ${nameRegex.images[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getServerCustomImages.
     * @return A collection of values returned by getServerCustomImages.
     */
    public suspend fun getServerCustomImages(argument: GetServerCustomImagesPlainArgs): GetServerCustomImagesResult =
        getServerCustomImagesResultToKotlin(getServerCustomImagesPlain(argument.toJava()).await())

    /**
     * @see [getServerCustomImages].
     * @param ids A list of Custom Image IDs.
     * @param nameRegex A regex string to filter results by Custom Image name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getServerCustomImages.
     */
    public suspend fun getServerCustomImages(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetServerCustomImagesResult {
        val argument = GetServerCustomImagesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getServerCustomImagesResultToKotlin(getServerCustomImagesPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerCustomImages].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;simpleapplicationserver&#46;kotlin&#46;inputs&#46;GetServerCustomImagesPlainArgs].
     * @return A collection of values returned by getServerCustomImages.
     */
    public suspend fun getServerCustomImages(argument: suspend GetServerCustomImagesPlainArgsBuilder.() -> Unit): GetServerCustomImagesResult {
        val builder = GetServerCustomImagesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerCustomImagesResultToKotlin(getServerCustomImagesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Simple Application Server Disks of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.143.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.simpleapplicationserver.getServerDisks({
     *     ids: ["example_id"],
     * });
     * export const simpleApplicationServerDiskId1 = ids.then(ids => ids.disks?.[0]?.id);
     * const nameRegex = alicloud.simpleapplicationserver.getServerDisks({
     *     nameRegex: "^my-Disk",
     * });
     * export const simpleApplicationServerDiskId2 = nameRegex.then(nameRegex => nameRegex.disks?.[0]?.id);
     * const status = alicloud.simpleapplicationserver.getServerDisks({
     *     status: "In_use",
     * });
     * export const simpleApplicationServerDiskId3 = status.then(status => status.disks?.[0]?.id);
     * const instanceId = alicloud.simpleapplicationserver.getServerDisks({
     *     instanceId: "example_value",
     * });
     * export const simpleApplicationServerDiskId4 = instanceId.then(instanceId => instanceId.disks?.[0]?.id);
     * const diskType = alicloud.simpleapplicationserver.getServerDisks({
     *     diskType: "System",
     * });
     * export const simpleApplicationServerDiskId5 = diskType.then(diskType => diskType.disks?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.simpleapplicationserver.get_server_disks(ids=["example_id"])
     * pulumi.export("simpleApplicationServerDiskId1", ids.disks[0].id)
     * name_regex = alicloud.simpleapplicationserver.get_server_disks(name_regex="^my-Disk")
     * pulumi.export("simpleApplicationServerDiskId2", name_regex.disks[0].id)
     * status = alicloud.simpleapplicationserver.get_server_disks(status="In_use")
     * pulumi.export("simpleApplicationServerDiskId3", status.disks[0].id)
     * instance_id = alicloud.simpleapplicationserver.get_server_disks(instance_id="example_value")
     * pulumi.export("simpleApplicationServerDiskId4", instance_id.disks[0].id)
     * disk_type = alicloud.simpleapplicationserver.get_server_disks(disk_type="System")
     * pulumi.export("simpleApplicationServerDiskId5", disk_type.disks[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.SimpleApplicationServer.GetServerDisks.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.SimpleApplicationServer.GetServerDisks.Invoke(new()
     *     {
     *         NameRegex = "^my-Disk",
     *     });
     *     var status = AliCloud.SimpleApplicationServer.GetServerDisks.Invoke(new()
     *     {
     *         Status = "In_use",
     *     });
     *     var instanceId = AliCloud.SimpleApplicationServer.GetServerDisks.Invoke(new()
     *     {
     *         InstanceId = "example_value",
     *     });
     *     var diskType = AliCloud.SimpleApplicationServer.GetServerDisks.Invoke(new()
     *     {
     *         DiskType = "System",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["simpleApplicationServerDiskId1"] = ids&#46;Apply(getServerDisksResult => getServerDisksResult&#46;Disks[0]?.Id),
     *         ["simpleApplicationServerDiskId2"] = nameRegex&#46;Apply(getServerDisksResult => getServerDisksResult&#46;Disks[0]?.Id),
     *         ["simpleApplicationServerDiskId3"] = status&#46;Apply(getServerDisksResult => getServerDisksResult&#46;Disks[0]?.Id),
     *         ["simpleApplicationServerDiskId4"] = instanceId&#46;Apply(getServerDisksResult => getServerDisksResult&#46;Disks[0]?.Id),
     *         ["simpleApplicationServerDiskId5"] = diskType&#46;Apply(getServerDisksResult => getServerDisksResult&#46;Disks[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/simpleapplicationserver"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := simpleapplicationserver.GetServerDisks(ctx, &simpleapplicationserver.GetServerDisksArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("simpleApplicationServerDiskId1", ids.Disks[0].Id)
     * 		nameRegex, err := simpleapplicationserver.GetServerDisks(ctx, &simpleapplicationserver.GetServerDisksArgs{
     * 			NameRegex: pulumi.StringRef("^my-Disk"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("simpleApplicationServerDiskId2", nameRegex.Disks[0].Id)
     * 		status, err := simpleapplicationserver.GetServerDisks(ctx, &simpleapplicationserver.GetServerDisksArgs{
     * 			Status: pulumi.StringRef("In_use"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("simpleApplicationServerDiskId3", status.Disks[0].Id)
     * 		instanceId, err := simpleapplicationserver.GetServerDisks(ctx, &simpleapplicationserver.GetServerDisksArgs{
     * 			InstanceId: pulumi.StringRef("example_value"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("simpleApplicationServerDiskId4", instanceId.Disks[0].Id)
     * 		diskType, err := simpleapplicationserver.GetServerDisks(ctx, &simpleapplicationserver.GetServerDisksArgs{
     * 			DiskType: pulumi.StringRef("System"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("simpleApplicationServerDiskId5", diskType.Disks[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.simpleapplicationserver.SimpleapplicationserverFunctions;
     * import com.pulumi.alicloud.simpleapplicationserver.inputs.GetServerDisksArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = SimpleapplicationserverFunctions.getServerDisks(GetServerDisksArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("simpleApplicationServerDiskId1", ids.applyValue(getServerDisksResult -> getServerDisksResult.disks()[0].id()));
     *         final var nameRegex = SimpleapplicationserverFunctions.getServerDisks(GetServerDisksArgs.builder()
     *             .nameRegex("^my-Disk")
     *             .build());
     *         ctx.export("simpleApplicationServerDiskId2", nameRegex.applyValue(getServerDisksResult -> getServerDisksResult.disks()[0].id()));
     *         final var status = SimpleapplicationserverFunctions.getServerDisks(GetServerDisksArgs.builder()
     *             .status("In_use")
     *             .build());
     *         ctx.export("simpleApplicationServerDiskId3", status.applyValue(getServerDisksResult -> getServerDisksResult.disks()[0].id()));
     *         final var instanceId = SimpleapplicationserverFunctions.getServerDisks(GetServerDisksArgs.builder()
     *             .instanceId("example_value")
     *             .build());
     *         ctx.export("simpleApplicationServerDiskId4", instanceId.applyValue(getServerDisksResult -> getServerDisksResult.disks()[0].id()));
     *         final var diskType = SimpleapplicationserverFunctions.getServerDisks(GetServerDisksArgs.builder()
     *             .diskType("System")
     *             .build());
     *         ctx.export("simpleApplicationServerDiskId5", diskType.applyValue(getServerDisksResult -> getServerDisksResult.disks()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:simpleapplicationserver:getServerDisks
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:simpleapplicationserver:getServerDisks
     *       Arguments:
     *         nameRegex: ^my-Disk
     *   status:
     *     fn::invoke:
     *       Function: alicloud:simpleapplicationserver:getServerDisks
     *       Arguments:
     *         status: In_use
     *   instanceId:
     *     fn::invoke:
     *       Function: alicloud:simpleapplicationserver:getServerDisks
     *       Arguments:
     *         instanceId: example_value
     *   diskType:
     *     fn::invoke:
     *       Function: alicloud:simpleapplicationserver:getServerDisks
     *       Arguments:
     *         diskType: System
     * outputs:
     *   simpleApplicationServerDiskId1: ${ids.disks[0].id}
     *   simpleApplicationServerDiskId2: ${nameRegex.disks[0].id}
     *   simpleApplicationServerDiskId3: ${status.disks[0].id}
     *   simpleApplicationServerDiskId4: ${instanceId.disks[0].id}
     *   simpleApplicationServerDiskId5: ${diskType.disks[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getServerDisks.
     * @return A collection of values returned by getServerDisks.
     */
    public suspend fun getServerDisks(argument: GetServerDisksPlainArgs): GetServerDisksResult =
        getServerDisksResultToKotlin(getServerDisksPlain(argument.toJava()).await())

    /**
     * @see [getServerDisks].
     * @param diskType The type of the disk. Possible values: `System`, `Data`.
     * @param ids A list of Disk IDs.
     * @param instanceId The ID of the simple application server to which the disk is attached.
     * @param nameRegex A regex string to filter results by Disk name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the disk. Valid values: `ReIniting`, `Creating`, `In_Use`, `Available`, `Attaching`, `Detaching`.
     * @return A collection of values returned by getServerDisks.
     */
    public suspend fun getServerDisks(
        diskType: String? = null,
        ids: List<String>? = null,
        instanceId: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetServerDisksResult {
        val argument = GetServerDisksPlainArgs(
            diskType = diskType,
            ids = ids,
            instanceId = instanceId,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getServerDisksResultToKotlin(getServerDisksPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerDisks].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;simpleapplicationserver&#46;kotlin&#46;inputs&#46;GetServerDisksPlainArgs].
     * @return A collection of values returned by getServerDisks.
     */
    public suspend fun getServerDisks(argument: suspend GetServerDisksPlainArgsBuilder.() -> Unit): GetServerDisksResult {
        val builder = GetServerDisksPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerDisksResultToKotlin(getServerDisksPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Simple Application Server Firewall Rules of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.143.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.simpleapplicationserver.getServerFirewallRules({
     *     instanceId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const simpleApplicationServerFirewallRuleId1 = ids.then(ids => ids.rules?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.simpleapplicationserver.get_server_firewall_rules(instance_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("simpleApplicationServerFirewallRuleId1", ids.rules[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.SimpleApplicationServer.GetServerFirewallRules.Invoke(new()
     *     {
     *         InstanceId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["simpleApplicationServerFirewallRuleId1"] = ids&#46;Apply(getServerFirewallRulesResult => getServerFirewallRulesResult&#46;Rules[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/simpleapplicationserver"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := simpleapplicationserver.GetServerFirewallRules(ctx, &simpleapplicationserver.GetServerFirewallRulesArgs{
     * 			InstanceId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("simpleApplicationServerFirewallRuleId1", ids.Rules[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.simpleapplicationserver.SimpleapplicationserverFunctions;
     * import com.pulumi.alicloud.simpleapplicationserver.inputs.GetServerFirewallRulesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = SimpleapplicationserverFunctions.getServerFirewallRules(GetServerFirewallRulesArgs.builder()
     *             .instanceId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("simpleApplicationServerFirewallRuleId1", ids.applyValue(getServerFirewallRulesResult -> getServerFirewallRulesResult.rules()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:simpleapplicationserver:getServerFirewallRules
     *       Arguments:
     *         instanceId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     * outputs:
     *   simpleApplicationServerFirewallRuleId1: ${ids.rules[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getServerFirewallRules.
     * @return A collection of values returned by getServerFirewallRules.
     */
    public suspend fun getServerFirewallRules(argument: GetServerFirewallRulesPlainArgs): GetServerFirewallRulesResult =
        getServerFirewallRulesResultToKotlin(getServerFirewallRulesPlain(argument.toJava()).await())

    /**
     * @see [getServerFirewallRules].
     * @param ids A list of Firewall Rule IDs.
     * @param instanceId Alibaba Cloud simple application server instance ID.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getServerFirewallRules.
     */
    public suspend fun getServerFirewallRules(
        ids: List<String>? = null,
        instanceId: String,
        outputFile: String? = null,
    ): GetServerFirewallRulesResult {
        val argument = GetServerFirewallRulesPlainArgs(
            ids = ids,
            instanceId = instanceId,
            outputFile = outputFile,
        )
        return getServerFirewallRulesResultToKotlin(getServerFirewallRulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerFirewallRules].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;simpleapplicationserver&#46;kotlin&#46;inputs&#46;GetServerFirewallRulesPlainArgs].
     * @return A collection of values returned by getServerFirewallRules.
     */
    public suspend fun getServerFirewallRules(argument: suspend GetServerFirewallRulesPlainArgsBuilder.() -> Unit): GetServerFirewallRulesResult {
        val builder = GetServerFirewallRulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerFirewallRulesResultToKotlin(getServerFirewallRulesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Simple Application Server Plans of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.135.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.simpleapplicationserver.getServerPlans({
     *     memory: 1,
     *     bandwidth: 3,
     *     diskSize: 40,
     *     flow: 6,
     *     core: 2,
     * });
     * export const simpleApplicationServerPlanId1 = ids.plans[0].id;
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.simpleapplicationserver.get_server_plans(memory=1,
     *     bandwidth=3,
     *     disk_size=40,
     *     flow=6,
     *     core=2)
     * pulumi.export("simpleApplicationServerPlanId1", ids["plans"][0]["id"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.SimpleApplicationServer.GetServerPlans.Invoke(new()
     *     {
     *         Memory = 1,
     *         Bandwidth = 3,
     *         DiskSize = 40,
     *         Flow = 6,
     *         Core = 2,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["simpleApplicationServerPlanId1"] = ids&#46;Plans[0].Id,
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/simpleapplicationserver"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := simpleapplicationserver.GetServerPlans(ctx, &simpleapplicationserver.GetServerPlansArgs{
     * 			Memory:    pulumi.IntRef(1),
     * 			Bandwidth: pulumi.IntRef(3),
     * 			DiskSize:  pulumi.IntRef(40),
     * 			Flow:      pulumi.IntRef(6),
     * 			Core:      pulumi.IntRef(2),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("simpleApplicationServerPlanId1", ids.Plans[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.simpleapplicationserver.SimpleapplicationserverFunctions;
     * import com.pulumi.alicloud.simpleapplicationserver.inputs.GetServerPlansArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SimpleapplicationserverFunctions.getServerPlans(GetServerPlansArgs.builder()
     *             .memory(1)
     *             .bandwidth(3)
     *             .diskSize(40)
     *             .flow(6)
     *             .core(2)
     *             .build());
     *         ctx.export("simpleApplicationServerPlanId1", ids.plans()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:simpleapplicationserver:getServerPlans
     *       Arguments:
     *         memory: 1
     *         bandwidth: 3
     *         diskSize: 40
     *         flow: 6
     *         core: 2
     * outputs:
     *   simpleApplicationServerPlanId1: ${ids.plans[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getServerPlans.
     * @return A collection of values returned by getServerPlans.
     */
    public suspend fun getServerPlans(argument: GetServerPlansPlainArgs): GetServerPlansResult =
        getServerPlansResultToKotlin(getServerPlansPlain(argument.toJava()).await())

    /**
     * @see [getServerPlans].
     * @param bandwidth The peak bandwidth. Unit: Mbit/s.
     * @param core The number of CPU cores.
     * @param diskSize The size of the enhanced SSD (ESSD). Unit: GB.
     * @param flow The monthly data transfer quota. Unit: GB.
     * @param ids A list of Instance Plan IDs.
     * @param memory The memory size. Unit: GB.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param platform The platform of Plan supported. Valid values: ["Linux", "Windows"].
     * @return A collection of values returned by getServerPlans.
     */
    public suspend fun getServerPlans(
        bandwidth: Int? = null,
        core: Int? = null,
        diskSize: Int? = null,
        flow: Int? = null,
        ids: List<String>? = null,
        memory: Int? = null,
        outputFile: String? = null,
        platform: String? = null,
    ): GetServerPlansResult {
        val argument = GetServerPlansPlainArgs(
            bandwidth = bandwidth,
            core = core,
            diskSize = diskSize,
            flow = flow,
            ids = ids,
            memory = memory,
            outputFile = outputFile,
            platform = platform,
        )
        return getServerPlansResultToKotlin(getServerPlansPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerPlans].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;simpleapplicationserver&#46;kotlin&#46;inputs&#46;GetServerPlansPlainArgs].
     * @return A collection of values returned by getServerPlans.
     */
    public suspend fun getServerPlans(argument: suspend GetServerPlansPlainArgsBuilder.() -> Unit): GetServerPlansResult {
        val builder = GetServerPlansPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerPlansResultToKotlin(getServerPlansPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Simple Application Server Snapshots of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.143.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.simpleapplicationserver.getServerSnapshots({
     *     ids: ["example_id"],
     * });
     * export const simpleApplicationServerSnapshotId1 = ids.then(ids => ids.snapshots?.[0]?.id);
     * const nameRegex = alicloud.simpleapplicationserver.getServerSnapshots({
     *     nameRegex: "^my-Snapshot",
     * });
     * export const simpleApplicationServerSnapshotId2 = nameRegex.then(nameRegex => nameRegex.snapshots?.[0]?.id);
     * const diskIdConf = alicloud.simpleapplicationserver.getServerSnapshots({
     *     ids: ["example_id"],
     *     diskId: "example_value",
     * });
     * export const simpleApplicationServerSnapshotId3 = diskIdConf.then(diskIdConf => diskIdConf.snapshots?.[0]?.id);
     * const instanceIdConf = alicloud.simpleapplicationserver.getServerSnapshots({
     *     ids: ["example_id"],
     *     instanceId: "example_value",
     * });
     * export const simpleApplicationServerSnapshotId4 = instanceIdConf.then(instanceIdConf => instanceIdConf.snapshots?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.simpleapplicationserver.get_server_snapshots(ids=["example_id"])
     * pulumi.export("simpleApplicationServerSnapshotId1", ids.snapshots[0].id)
     * name_regex = alicloud.simpleapplicationserver.get_server_snapshots(name_regex="^my-Snapshot")
     * pulumi.export("simpleApplicationServerSnapshotId2", name_regex.snapshots[0].id)
     * disk_id_conf = alicloud.simpleapplicationserver.get_server_snapshots(ids=["example_id"],
     *     disk_id="example_value")
     * pulumi.export("simpleApplicationServerSnapshotId3", disk_id_conf.snapshots[0].id)
     * instance_id_conf = alicloud.simpleapplicationserver.get_server_snapshots(ids=["example_id"],
     *     instance_id="example_value")
     * pulumi.export("simpleApplicationServerSnapshotId4", instance_id_conf.snapshots[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.SimpleApplicationServer.GetServerSnapshots.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.SimpleApplicationServer.GetServerSnapshots.Invoke(new()
     *     {
     *         NameRegex = "^my-Snapshot",
     *     });
     *     var diskIdConf = AliCloud.SimpleApplicationServer.GetServerSnapshots.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         DiskId = "example_value",
     *     });
     *     var instanceIdConf = AliCloud.SimpleApplicationServer.GetServerSnapshots.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         InstanceId = "example_value",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["simpleApplicationServerSnapshotId1"] = ids&#46;Apply(getServerSnapshotsResult => getServerSnapshotsResult&#46;Snapshots[0]?.Id),
     *         ["simpleApplicationServerSnapshotId2"] = nameRegex&#46;Apply(getServerSnapshotsResult => getServerSnapshotsResult&#46;Snapshots[0]?.Id),
     *         ["simpleApplicationServerSnapshotId3"] = diskIdConf&#46;Apply(getServerSnapshotsResult => getServerSnapshotsResult&#46;Snapshots[0]?.Id),
     *         ["simpleApplicationServerSnapshotId4"] = instanceIdConf&#46;Apply(getServerSnapshotsResult => getServerSnapshotsResult&#46;Snapshots[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/simpleapplicationserver"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := simpleapplicationserver.GetServerSnapshots(ctx, &simpleapplicationserver.GetServerSnapshotsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("simpleApplicationServerSnapshotId1", ids.Snapshots[0].Id)
     * 		nameRegex, err := simpleapplicationserver.GetServerSnapshots(ctx, &simpleapplicationserver.GetServerSnapshotsArgs{
     * 			NameRegex: pulumi.StringRef("^my-Snapshot"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("simpleApplicationServerSnapshotId2", nameRegex.Snapshots[0].Id)
     * 		diskIdConf, err := simpleapplicationserver.GetServerSnapshots(ctx, &simpleapplicationserver.GetServerSnapshotsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			DiskId: pulumi.StringRef("example_value"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("simpleApplicationServerSnapshotId3", diskIdConf.Snapshots[0].Id)
     * 		instanceIdConf, err := simpleapplicationserver.GetServerSnapshots(ctx, &simpleapplicationserver.GetServerSnapshotsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			InstanceId: pulumi.StringRef("example_value"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("simpleApplicationServerSnapshotId4", instanceIdConf.Snapshots[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.simpleapplicationserver.SimpleapplicationserverFunctions;
     * import com.pulumi.alicloud.simpleapplicationserver.inputs.GetServerSnapshotsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = SimpleapplicationserverFunctions.getServerSnapshots(GetServerSnapshotsArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("simpleApplicationServerSnapshotId1", ids.applyValue(getServerSnapshotsResult -> getServerSnapshotsResult.snapshots()[0].id()));
     *         final var nameRegex = SimpleapplicationserverFunctions.getServerSnapshots(GetServerSnapshotsArgs.builder()
     *             .nameRegex("^my-Snapshot")
     *             .build());
     *         ctx.export("simpleApplicationServerSnapshotId2", nameRegex.applyValue(getServerSnapshotsResult -> getServerSnapshotsResult.snapshots()[0].id()));
     *         final var diskIdConf = SimpleapplicationserverFunctions.getServerSnapshots(GetServerSnapshotsArgs.builder()
     *             .ids("example_id")
     *             .diskId("example_value")
     *             .build());
     *         ctx.export("simpleApplicationServerSnapshotId3", diskIdConf.applyValue(getServerSnapshotsResult -> getServerSnapshotsResult.snapshots()[0].id()));
     *         final var instanceIdConf = SimpleapplicationserverFunctions.getServerSnapshots(GetServerSnapshotsArgs.builder()
     *             .ids("example_id")
     *             .instanceId("example_value")
     *             .build());
     *         ctx.export("simpleApplicationServerSnapshotId4", instanceIdConf.applyValue(getServerSnapshotsResult -> getServerSnapshotsResult.snapshots()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:simpleapplicationserver:getServerSnapshots
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:simpleapplicationserver:getServerSnapshots
     *       Arguments:
     *         nameRegex: ^my-Snapshot
     *   diskIdConf:
     *     fn::invoke:
     *       Function: alicloud:simpleapplicationserver:getServerSnapshots
     *       Arguments:
     *         ids:
     *           - example_id
     *         diskId: example_value
     *   instanceIdConf:
     *     fn::invoke:
     *       Function: alicloud:simpleapplicationserver:getServerSnapshots
     *       Arguments:
     *         ids:
     *           - example_id
     *         instanceId: example_value
     * outputs:
     *   simpleApplicationServerSnapshotId1: ${ids.snapshots[0].id}
     *   simpleApplicationServerSnapshotId2: ${nameRegex.snapshots[0].id}
     *   simpleApplicationServerSnapshotId3: ${diskIdConf.snapshots[0].id}
     *   simpleApplicationServerSnapshotId4: ${instanceIdConf.snapshots[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getServerSnapshots.
     * @return A collection of values returned by getServerSnapshots.
     */
    public suspend fun getServerSnapshots(argument: GetServerSnapshotsPlainArgs): GetServerSnapshotsResult =
        getServerSnapshotsResultToKotlin(getServerSnapshotsPlain(argument.toJava()).await())

    /**
     * @see [getServerSnapshots].
     * @param diskId The ID of the disk.
     * @param ids A list of Snapshot IDs.
     * @param instanceId The ID of the simple application server.
     * @param nameRegex A regex string to filter results by Snapshot name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the snapshots. Valid values: `Progressing`, `Accomplished` and `Failed`.
     * @return A collection of values returned by getServerSnapshots.
     */
    public suspend fun getServerSnapshots(
        diskId: String? = null,
        ids: List<String>? = null,
        instanceId: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetServerSnapshotsResult {
        val argument = GetServerSnapshotsPlainArgs(
            diskId = diskId,
            ids = ids,
            instanceId = instanceId,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getServerSnapshotsResultToKotlin(getServerSnapshotsPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerSnapshots].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;simpleapplicationserver&#46;kotlin&#46;inputs&#46;GetServerSnapshotsPlainArgs].
     * @return A collection of values returned by getServerSnapshots.
     */
    public suspend fun getServerSnapshots(argument: suspend GetServerSnapshotsPlainArgsBuilder.() -> Unit): GetServerSnapshotsResult {
        val builder = GetServerSnapshotsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerSnapshotsResultToKotlin(getServerSnapshotsPlain(builtArgument.toJava()).await())
    }
}
