@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.simpleapplicationserver.kotlin.inputs

import com.pulumi.alicloud.simpleapplicationserver.inputs.GetImagesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getImages.
 * @property ids
 * @property imageType
 * @property nameRegex
 * @property outputFile
 * @property platform
 */
public data class GetImagesPlainArgs(
    public val ids: List<String>? = null,
    public val imageType: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val platform: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.simpleapplicationserver.inputs.GetImagesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.simpleapplicationserver.inputs.GetImagesPlainArgs =
        com.pulumi.alicloud.simpleapplicationserver.inputs.GetImagesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .imageType(imageType?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .platform(platform?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetImagesPlainArgs].
 */
@PulumiTagMarker
public class GetImagesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var imageType: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var platform: String? = null

    /**
     * @param value
     */
    @JvmName("muyxrktqqwfwrtyj")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values
     */
    @JvmName("kusnjafhdwmdnopr")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value
     */
    @JvmName("tdujbsnkdprjupyh")
    public suspend fun imageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.imageType = mapped
    }

    /**
     * @param value
     */
    @JvmName("wkyjltothehokbks")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value
     */
    @JvmName("ccgjpppijxbunmkm")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("bduovqovfqgalkme")
    public suspend fun platform(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.platform = mapped
    }

    internal fun build(): GetImagesPlainArgs = GetImagesPlainArgs(
        ids = ids,
        imageType = imageType,
        nameRegex = nameRegex,
        outputFile = outputFile,
        platform = platform,
    )
}
