@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.simpleapplicationserver.kotlin.inputs

import com.pulumi.alicloud.simpleapplicationserver.inputs.GetServerDisksPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getServerDisks.
 * @property diskType The type of the disk. Possible values: `System`, `Data`.
 * @property ids A list of Disk IDs.
 * @property instanceId The ID of the simple application server to which the disk is attached.
 * @property nameRegex A regex string to filter results by Disk name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the disk. Valid values: `ReIniting`, `Creating`, `In_Use`, `Available`, `Attaching`, `Detaching`.
 */
public data class GetServerDisksPlainArgs(
    public val diskType: String? = null,
    public val ids: List<String>? = null,
    public val instanceId: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.simpleapplicationserver.inputs.GetServerDisksPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.simpleapplicationserver.inputs.GetServerDisksPlainArgs = com.pulumi.alicloud.simpleapplicationserver.inputs.GetServerDisksPlainArgs.builder()
        .diskType(diskType?.let({ args0 -> args0 }))
        .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
        .instanceId(instanceId?.let({ args0 -> args0 }))
        .nameRegex(nameRegex?.let({ args0 -> args0 }))
        .outputFile(outputFile?.let({ args0 -> args0 }))
        .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServerDisksPlainArgs].
 */
@PulumiTagMarker
public class GetServerDisksPlainArgsBuilder internal constructor() {
    private var diskType: String? = null

    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value The type of the disk. Possible values: `System`, `Data`.
     */
    @JvmName("ftbuedfrguwpmupq")
    public suspend fun diskType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.diskType = mapped
    }

    /**
     * @param value A list of Disk IDs.
     */
    @JvmName("gywiwqcbecloggam")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Disk IDs.
     */
    @JvmName("uofbxlkdsdqokapo")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The ID of the simple application server to which the disk is attached.
     */
    @JvmName("gllqhoklghdlgtip")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value A regex string to filter results by Disk name.
     */
    @JvmName("fparxccwskchkfys")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("gkqgirtnofmioyvi")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the disk. Valid values: `ReIniting`, `Creating`, `In_Use`, `Available`, `Attaching`, `Detaching`.
     */
    @JvmName("afhnkaobwibkgaly")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetServerDisksPlainArgs = GetServerDisksPlainArgs(
        diskType = diskType,
        ids = ids,
        instanceId = instanceId,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
