@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.simpleapplicationserver.kotlin.inputs

import com.pulumi.alicloud.simpleapplicationserver.inputs.GetServerFirewallRulesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getServerFirewallRules.
 * @property ids A list of Firewall Rule IDs.
 * @property instanceId Alibaba Cloud simple application server instance ID.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetServerFirewallRulesPlainArgs(
    public val ids: List<String>? = null,
    public val instanceId: String,
    public val outputFile: String? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.simpleapplicationserver.inputs.GetServerFirewallRulesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.simpleapplicationserver.inputs.GetServerFirewallRulesPlainArgs =
        com.pulumi.alicloud.simpleapplicationserver.inputs.GetServerFirewallRulesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServerFirewallRulesPlainArgs].
 */
@PulumiTagMarker
public class GetServerFirewallRulesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var outputFile: String? = null

    /**
     * @param value A list of Firewall Rule IDs.
     */
    @JvmName("ypadnaybctylustl")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Firewall Rule IDs.
     */
    @JvmName("fpgggcybmwghecoe")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value Alibaba Cloud simple application server instance ID.
     */
    @JvmName("klcndsxovttthyvp")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("xyrkguqatumfbpni")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetServerFirewallRulesPlainArgs = GetServerFirewallRulesPlainArgs(
        ids = ids,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        outputFile = outputFile,
    )
}
