@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.simpleapplicationserver.kotlin.inputs

import com.pulumi.alicloud.simpleapplicationserver.inputs.GetServerPlansPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getServerPlans.
 * @property bandwidth The peak bandwidth. Unit: Mbit/s.
 * @property core The number of CPU cores.
 * @property diskSize The size of the enhanced SSD (ESSD). Unit: GB.
 * @property flow The monthly data transfer quota. Unit: GB.
 * @property ids A list of Instance Plan IDs.
 * @property memory The memory size. Unit: GB.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property platform The platform of Plan supported. Valid values: ["Linux", "Windows"].
 */
public data class GetServerPlansPlainArgs(
    public val bandwidth: Int? = null,
    public val core: Int? = null,
    public val diskSize: Int? = null,
    public val flow: Int? = null,
    public val ids: List<String>? = null,
    public val memory: Int? = null,
    public val outputFile: String? = null,
    public val platform: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.simpleapplicationserver.inputs.GetServerPlansPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.simpleapplicationserver.inputs.GetServerPlansPlainArgs = com.pulumi.alicloud.simpleapplicationserver.inputs.GetServerPlansPlainArgs.builder()
        .bandwidth(bandwidth?.let({ args0 -> args0 }))
        .core(core?.let({ args0 -> args0 }))
        .diskSize(diskSize?.let({ args0 -> args0 }))
        .flow(flow?.let({ args0 -> args0 }))
        .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
        .memory(memory?.let({ args0 -> args0 }))
        .outputFile(outputFile?.let({ args0 -> args0 }))
        .platform(platform?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServerPlansPlainArgs].
 */
@PulumiTagMarker
public class GetServerPlansPlainArgsBuilder internal constructor() {
    private var bandwidth: Int? = null

    private var core: Int? = null

    private var diskSize: Int? = null

    private var flow: Int? = null

    private var ids: List<String>? = null

    private var memory: Int? = null

    private var outputFile: String? = null

    private var platform: String? = null

    /**
     * @param value The peak bandwidth. Unit: Mbit/s.
     */
    @JvmName("lmnmqvbhcfpjavah")
    public suspend fun bandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.bandwidth = mapped
    }

    /**
     * @param value The number of CPU cores.
     */
    @JvmName("bmonermojnejvkll")
    public suspend fun core(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.core = mapped
    }

    /**
     * @param value The size of the enhanced SSD (ESSD). Unit: GB.
     */
    @JvmName("qptldrtvytajhxiv")
    public suspend fun diskSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.diskSize = mapped
    }

    /**
     * @param value The monthly data transfer quota. Unit: GB.
     */
    @JvmName("krwrerjtdkdnwdgy")
    public suspend fun flow(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.flow = mapped
    }

    /**
     * @param value A list of Instance Plan IDs.
     */
    @JvmName("akasbspkputgjhrp")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Instance Plan IDs.
     */
    @JvmName("bmdqewvipovlhcyd")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The memory size. Unit: GB.
     */
    @JvmName("etcocqhsockajyth")
    public suspend fun memory(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.memory = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("reeymtjokbrfcbgy")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The platform of Plan supported. Valid values: ["Linux", "Windows"].
     */
    @JvmName("dqquyxwebsmxfagc")
    public suspend fun platform(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.platform = mapped
    }

    internal fun build(): GetServerPlansPlainArgs = GetServerPlansPlainArgs(
        bandwidth = bandwidth,
        core = core,
        diskSize = diskSize,
        flow = flow,
        ids = ids,
        memory = memory,
        outputFile = outputFile,
        platform = platform,
    )
}
