@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.simpleapplicationserver.kotlin.inputs

import com.pulumi.alicloud.simpleapplicationserver.inputs.GetServerSnapshotsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getServerSnapshots.
 * @property diskId The ID of the disk.
 * @property ids A list of Snapshot IDs.
 * @property instanceId The ID of the simple application server.
 * @property nameRegex A regex string to filter results by Snapshot name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the snapshots. Valid values: `Progressing`, `Accomplished` and `Failed`.
 */
public data class GetServerSnapshotsPlainArgs(
    public val diskId: String? = null,
    public val ids: List<String>? = null,
    public val instanceId: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.simpleapplicationserver.inputs.GetServerSnapshotsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.simpleapplicationserver.inputs.GetServerSnapshotsPlainArgs =
        com.pulumi.alicloud.simpleapplicationserver.inputs.GetServerSnapshotsPlainArgs.builder()
            .diskId(diskId?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServerSnapshotsPlainArgs].
 */
@PulumiTagMarker
public class GetServerSnapshotsPlainArgsBuilder internal constructor() {
    private var diskId: String? = null

    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value The ID of the disk.
     */
    @JvmName("eycmdvkpqekhscnb")
    public suspend fun diskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.diskId = mapped
    }

    /**
     * @param value A list of Snapshot IDs.
     */
    @JvmName("mnswkijfkfjqvvqn")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Snapshot IDs.
     */
    @JvmName("jhgmlepdwjqoafyb")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The ID of the simple application server.
     */
    @JvmName("sgkpafsyxfmlasyf")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value A regex string to filter results by Snapshot name.
     */
    @JvmName("vexrjotjgmknggor")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("caskaiywqtkjhhdl")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the snapshots. Valid values: `Progressing`, `Accomplished` and `Failed`.
     */
    @JvmName("wbibpevumeyvfkqq")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetServerSnapshotsPlainArgs = GetServerSnapshotsPlainArgs(
        diskId = diskId,
        ids = ids,
        instanceId = instanceId,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
