@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.simpleapplicationserver.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description The description of the image.
 * @property id The ID of the Instance Image.
 * @property imageId The ID of the image.
 * @property imageName The name of the resource.
 * @property imageType The type of the image. Valid values: `app`, `custom`, `system`.
 * @property platform The platform of Plan supported.
 */
public data class GetImagesImage(
    public val description: String,
    public val id: String,
    public val imageId: String,
    public val imageName: String,
    public val imageType: String,
    public val platform: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.simpleapplicationserver.outputs.GetImagesImage): GetImagesImage = GetImagesImage(
            description = javaType.description(),
            id = javaType.id(),
            imageId = javaType.imageId(),
            imageName = javaType.imageName(),
            imageType = javaType.imageType(),
            platform = javaType.platform(),
        )
    }
}
