@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.simpleapplicationserver.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property businessStatus The billing status of the simple application server. Valid values: `Normal`, `Expired` and `Overdue`.
 * @property createTime The time when the simple application server was created.
 * @property ddosStatus The DDoS protection status. Valid values: `Normal`, `BlackHole`, and `Defense`.
 * @property expiredTime The time when the simple application server expires.
 * @property id The ID of the Instance.
 * @property imageId The ID of the simple application server Image.
 * @property innerIpAddress The internal IP address of the simple application server.
 * @property instanceId The ID of the simple application server.
 * @property instanceName The name of the resource.
 * @property paymentType The billing method of the simple application server.
 * @property planId The ID of the simple application server plan.
 * @property publicIpAddress The public IP address of the simple application server.
 * @property status The status of the resource.
 */
public data class GetInstancesInstance(
    public val businessStatus: String,
    public val createTime: String,
    public val ddosStatus: String,
    public val expiredTime: String,
    public val id: String,
    public val imageId: String,
    public val innerIpAddress: String,
    public val instanceId: String,
    public val instanceName: String,
    public val paymentType: String,
    public val planId: String,
    public val publicIpAddress: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.simpleapplicationserver.outputs.GetInstancesInstance): GetInstancesInstance = GetInstancesInstance(
            businessStatus = javaType.businessStatus(),
            createTime = javaType.createTime(),
            ddosStatus = javaType.ddosStatus(),
            expiredTime = javaType.expiredTime(),
            id = javaType.id(),
            imageId = javaType.imageId(),
            innerIpAddress = javaType.innerIpAddress(),
            instanceId = javaType.instanceId(),
            instanceName = javaType.instanceName(),
            paymentType = javaType.paymentType(),
            planId = javaType.planId(),
            publicIpAddress = javaType.publicIpAddress(),
            status = javaType.status(),
        )
    }
}
