@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.simpleapplicationserver.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property customImageId The first ID of the resource.
 * @property customImageName The name of the resource.
 * @property description Image description information.
 * @property id The ID of the Custom Image.
 * @property platform The type of operating system used by the Mirror. Valid values: `Linux`, `Windows`.
 */
public data class GetServerCustomImagesImage(
    public val customImageId: String,
    public val customImageName: String,
    public val description: String,
    public val id: String,
    public val platform: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.simpleapplicationserver.outputs.GetServerCustomImagesImage): GetServerCustomImagesImage = GetServerCustomImagesImage(
            customImageId = javaType.customImageId(),
            customImageName = javaType.customImageName(),
            description = javaType.description(),
            id = javaType.id(),
            platform = javaType.platform(),
        )
    }
}
