@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.simpleapplicationserver.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getServerCustomImages.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property images
 * @property nameRegex
 * @property names
 * @property outputFile
 */
public data class GetServerCustomImagesResult(
    public val id: String,
    public val ids: List<String>,
    public val images: List<GetServerCustomImagesImage>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.simpleapplicationserver.outputs.GetServerCustomImagesResult): GetServerCustomImagesResult = GetServerCustomImagesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            images = javaType.images().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.simpleapplicationserver.kotlin.outputs.GetServerCustomImagesImage.Companion.toKotlin(args0)
                })
            }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
