@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.simpleapplicationserver.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property category Disk type. Possible values: `ESSD`, `SSD`.
 * @property createTime The time when the disk was created. The time follows the ISO 8601 standard in the `yyyy-MM-ddTHH:mm:ssZ` format. The time is displayed in UTC.
 * @property device The device name of the disk on the simple application server.
 * @property diskId The first ID of the resource.
 * @property diskName The name of the resource.
 * @property diskType The type of the disk. Possible values: `System`, `Data`.
 * @property id The ID of the Disk.
 * @property instanceId Alibaba Cloud simple application server instance ID.
 * @property paymentType The payment type of the resource. Valid values: `PayAsYouGo`, `Subscription`.
 * @property size The size of the disk. Unit: `GB`.
 * @property status The status of the disk. Valid values: `ReIniting`, `Creating`, `In_Use`, `Available`, `Attaching`, `Detaching`.
 */
public data class GetServerDisksDisk(
    public val category: String,
    public val createTime: String,
    public val device: String,
    public val diskId: String,
    public val diskName: String,
    public val diskType: String,
    public val id: String,
    public val instanceId: String,
    public val paymentType: String,
    public val size: Int,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.simpleapplicationserver.outputs.GetServerDisksDisk): GetServerDisksDisk = GetServerDisksDisk(
            category = javaType.category(),
            createTime = javaType.createTime(),
            device = javaType.device(),
            diskId = javaType.diskId(),
            diskName = javaType.diskName(),
            diskType = javaType.diskType(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            paymentType = javaType.paymentType(),
            size = javaType.size(),
            status = javaType.status(),
        )
    }
}
