@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.simpleapplicationserver.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getServerFirewallRules.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instanceId
 * @property outputFile
 * @property rules
 */
public data class GetServerFirewallRulesResult(
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String,
    public val outputFile: String? = null,
    public val rules: List<GetServerFirewallRulesRule>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.simpleapplicationserver.outputs.GetServerFirewallRulesResult): GetServerFirewallRulesResult = GetServerFirewallRulesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceId = javaType.instanceId(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.simpleapplicationserver.kotlin.outputs.GetServerFirewallRulesRule.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
