@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.simpleapplicationserver.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property firewallRuleId The ID of the firewall rule.
 * @property id The ID of the Firewall Rule. The value formats as `<instance_id>:<firewall_rule_id>`.
 * @property instanceId Alibaba Cloud simple application server instance ID.
 * @property port The port range of the firewall rule.
 * @property remark The remarks of the firewall rule.
 * @property ruleProtocol The transport layer protocol. Valid values: `Tcp`, `Udp`, `TcpAndUdp`.
 */
public data class GetServerFirewallRulesRule(
    public val firewallRuleId: String,
    public val id: String,
    public val instanceId: String,
    public val port: String,
    public val remark: String,
    public val ruleProtocol: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.simpleapplicationserver.outputs.GetServerFirewallRulesRule): GetServerFirewallRulesRule = GetServerFirewallRulesRule(
            firewallRuleId = javaType.firewallRuleId(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            port = javaType.port(),
            remark = javaType.remark(),
            ruleProtocol = javaType.ruleProtocol(),
        )
    }
}
