@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.simpleapplicationserver.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bandwidth The peak bandwidth. Unit: Mbit/s.
 * @property core The number of CPU cores.
 * @property diskSize The size of the enhanced SSD (ESSD). Unit: GB.
 * @property flow The monthly data transfer quota. Unit: GB.
 * @property id The ID of the Instance Plan.
 * @property memory The memory size. Unit: GB.
 * @property planId The ID of the Instance Plan.
 * @property supportPlatform The platform of Plan supported.
 */
public data class GetServerPlansPlan(
    public val bandwidth: Int,
    public val core: Int,
    public val diskSize: Int,
    public val flow: Int,
    public val id: String,
    public val memory: Int,
    public val planId: String,
    public val supportPlatform: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.simpleapplicationserver.outputs.GetServerPlansPlan): GetServerPlansPlan = GetServerPlansPlan(
            bandwidth = javaType.bandwidth(),
            core = javaType.core(),
            diskSize = javaType.diskSize(),
            flow = javaType.flow(),
            id = javaType.id(),
            memory = javaType.memory(),
            planId = javaType.planId(),
            supportPlatform = javaType.supportPlatform(),
        )
    }
}
