@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.simpleapplicationserver.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getServerPlans.
 * @property bandwidth
 * @property core
 * @property diskSize
 * @property flow
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property memory
 * @property outputFile
 * @property plans
 * @property platform
 */
public data class GetServerPlansResult(
    public val bandwidth: Int? = null,
    public val core: Int? = null,
    public val diskSize: Int? = null,
    public val flow: Int? = null,
    public val id: String,
    public val ids: List<String>,
    public val memory: Int? = null,
    public val outputFile: String? = null,
    public val plans: List<GetServerPlansPlan>,
    public val platform: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.simpleapplicationserver.outputs.GetServerPlansResult): GetServerPlansResult = GetServerPlansResult(
            bandwidth = javaType.bandwidth().map({ args0 -> args0 }).orElse(null),
            core = javaType.core().map({ args0 -> args0 }).orElse(null),
            diskSize = javaType.diskSize().map({ args0 -> args0 }).orElse(null),
            flow = javaType.flow().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            memory = javaType.memory().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            plans = javaType.plans().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.simpleapplicationserver.kotlin.outputs.GetServerPlansPlan.Companion.toKotlin(args0)
                })
            }),
            platform = javaType.platform().map({ args0 -> args0 }).orElse(null),
        )
    }
}
