@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.simpleapplicationserver.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getServerSnapshots.
 * @property diskId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instanceId
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property snapshots
 * @property status
 */
public data class GetServerSnapshotsResult(
    public val diskId: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val snapshots: List<GetServerSnapshotsSnapshot>,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.simpleapplicationserver.outputs.GetServerSnapshotsResult): GetServerSnapshotsResult = GetServerSnapshotsResult(
            diskId = javaType.diskId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceId = javaType.instanceId().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            snapshots = javaType.snapshots().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.simpleapplicationserver.kotlin.outputs.GetServerSnapshotsSnapshot.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
