@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.simpleapplicationserver.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime The time when the snapshot was created. The time follows the ISO 8601 standard in the `yyyy-MM-ddTHH:mm:ssZ` format. The time is displayed in UTC.
 * @property diskId The ID of the source disk. This parameter has a value even after the source disk is released.
 * @property id The ID of the Snapshot.
 * @property progress The progress of snapshot creation.
 * @property remark The remarks of the snapshot.
 * @property snapshotId The ID of the snapshot.
 * @property snapshotName The name of the snapshot.
 * @property sourceDiskType A snapshot of the source of a disk type. Possible values: `System`, `Data`.
 * @property status The status of the snapshots. Valid values: `Progressing`, `Accomplished` and `Failed`.
 */
public data class GetServerSnapshotsSnapshot(
    public val createTime: String,
    public val diskId: String,
    public val id: String,
    public val progress: String,
    public val remark: String,
    public val snapshotId: String,
    public val snapshotName: String,
    public val sourceDiskType: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.simpleapplicationserver.outputs.GetServerSnapshotsSnapshot): GetServerSnapshotsSnapshot = GetServerSnapshotsSnapshot(
            createTime = javaType.createTime(),
            diskId = javaType.diskId(),
            id = javaType.id(),
            progress = javaType.progress(),
            remark = javaType.remark(),
            snapshotId = javaType.snapshotId(),
            snapshotName = javaType.snapshotName(),
            sourceDiskType = javaType.sourceDiskType(),
            status = javaType.status(),
        )
    }
}
