@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin

import com.pulumi.alicloud.slb.kotlin.outputs.AclEntryList
import com.pulumi.alicloud.slb.kotlin.outputs.AclEntryList.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Acl].
 */
@PulumiTagMarker
public class AclResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AclArgs = AclArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AclArgsBuilder.() -> Unit) {
        val builder = AclArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Acl {
        val builtJavaResource = com.pulumi.alicloud.slb.Acl(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Acl(builtJavaResource)
    }
}

/**
 * An access control list contains multiple IP addresses or CIDR blocks.
 * The access control list can help you to define multiple instance listening dimension,
 * and to meet the multiple usage for single access control list.
 * Server Load Balancer allows you to configure access control for listeners.
 * You can configure different whitelists or blacklists for different listeners.
 * You can configure access control
 * when you create a listener or change access control configuration after a listener is created.
 * > **NOTE:** One access control list can be attached to many Listeners in different load balancer as whitelists or blacklists.
 * > **NOTE:** The maximum number of access control lists per region  is 50.
 * > **NOTE:** The maximum number of IP addresses added each time is 50.
 * > **NOTE:** The maximum number of entries per access control list is 300.
 * > **NOTE:** The maximum number of listeners that an access control list can be added to is 50.
 * For information about slb and how to use it, see [What is Server Load Balancer](https://www.alibabacloud.com/help/doc-detail/27539.htm).
 * For information about acl and how to use it, see [Configure an access control list](https://www.alibabacloud.com/help/doc-detail/70015.htm).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const acl = new alicloud.slb.Acl("acl", {
 *     name: "terraformslbaclconfig",
 *     ipVersion: "ipv4",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * acl = alicloud.slb.Acl("acl",
 *     name="terraformslbaclconfig",
 *     ip_version="ipv4")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var acl = new AliCloud.Slb.Acl("acl", new()
 *     {
 *         Name = "terraformslbaclconfig",
 *         IpVersion = "ipv4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := slb.NewAcl(ctx, "acl", &slb.AclArgs{
 * 			Name:      pulumi.String("terraformslbaclconfig"),
 * 			IpVersion: pulumi.String("ipv4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.slb.Acl;
 * import com.pulumi.alicloud.slb.AclArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var acl = new Acl("acl", AclArgs.builder()
 *             .name("terraformslbaclconfig")
 *             .ipVersion("ipv4")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   acl:
 *     type: alicloud:slb:Acl
 *     properties:
 *       name: terraformslbaclconfig
 *       ipVersion: ipv4
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Entry Block
 * The entry mapping supports the following:
 * * `entry` - (Optional, Computed) The CIDR blocks.
 * * `comment` - (Optional, Computed) The comment of the entry.
 * ## Import
 * Server Load balancer access control list can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:slb/acl:Acl example acl-abc123456
 * ```
 */
public class Acl internal constructor(
    override val javaResource: com.pulumi.alicloud.slb.Acl,
) : KotlinCustomResource(javaResource, AclMapper) {
    /**
     * A list of entry (CIDR blocks) to be added. It contains two sub-fields as `Entry Block` follows. **NOTE:** "Field 'entry_list' has been deprecated from provider version 1.162.0 and it will be removed in the future version. Please use the new resource 'alicloud_slb_acl_entry_attachment'.",
     */
    @Deprecated(
        message = """
  Field 'entry_list' has been deprecated from provider version 1.162.0 and it will be removed in the
      future version. Please use the new resource 'alicloud_slb_acl_entry_attachment'.
  """,
    )
    public val entryLists: Output<List<AclEntryList>>
        get() = javaResource.entryLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The IP Version of access control list is the type of its entry (IP addresses or CIDR blocks). It values ipv4/ipv6. Our plugin provides a default ip_version: "ipv4".
     */
    public val ipVersion: Output<String>?
        get() = javaResource.ipVersion().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of the access control list.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource group ID.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object AclMapper : ResourceMapper<Acl> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.slb.Acl::class == javaResource::class

    override fun map(javaResource: Resource): Acl = Acl(javaResource as com.pulumi.alicloud.slb.Acl)
}

/**
 * @see [Acl].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Acl].
 */
public suspend fun acl(name: String, block: suspend AclResourceBuilder.() -> Unit): Acl {
    val builder = AclResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Acl].
 * @param name The _unique_ name of the resulting resource.
 */
public fun acl(name: String): Acl {
    val builder = AclResourceBuilder()
    builder.name(name)
    return builder.build()
}
