@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin

import com.pulumi.alicloud.slb.AclArgs.builder
import com.pulumi.alicloud.slb.kotlin.inputs.AclEntryListArgs
import com.pulumi.alicloud.slb.kotlin.inputs.AclEntryListArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An access control list contains multiple IP addresses or CIDR blocks.
 * The access control list can help you to define multiple instance listening dimension,
 * and to meet the multiple usage for single access control list.
 * Server Load Balancer allows you to configure access control for listeners.
 * You can configure different whitelists or blacklists for different listeners.
 * You can configure access control
 * when you create a listener or change access control configuration after a listener is created.
 * > **NOTE:** One access control list can be attached to many Listeners in different load balancer as whitelists or blacklists.
 * > **NOTE:** The maximum number of access control lists per region  is 50.
 * > **NOTE:** The maximum number of IP addresses added each time is 50.
 * > **NOTE:** The maximum number of entries per access control list is 300.
 * > **NOTE:** The maximum number of listeners that an access control list can be added to is 50.
 * For information about slb and how to use it, see [What is Server Load Balancer](https://www.alibabacloud.com/help/doc-detail/27539.htm).
 * For information about acl and how to use it, see [Configure an access control list](https://www.alibabacloud.com/help/doc-detail/70015.htm).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const acl = new alicloud.slb.Acl("acl", {
 *     name: "terraformslbaclconfig",
 *     ipVersion: "ipv4",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * acl = alicloud.slb.Acl("acl",
 *     name="terraformslbaclconfig",
 *     ip_version="ipv4")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var acl = new AliCloud.Slb.Acl("acl", new()
 *     {
 *         Name = "terraformslbaclconfig",
 *         IpVersion = "ipv4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := slb.NewAcl(ctx, "acl", &slb.AclArgs{
 * 			Name:      pulumi.String("terraformslbaclconfig"),
 * 			IpVersion: pulumi.String("ipv4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.slb.Acl;
 * import com.pulumi.alicloud.slb.AclArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var acl = new Acl("acl", AclArgs.builder()
 *             .name("terraformslbaclconfig")
 *             .ipVersion("ipv4")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   acl:
 *     type: alicloud:slb:Acl
 *     properties:
 *       name: terraformslbaclconfig
 *       ipVersion: ipv4
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Entry Block
 * The entry mapping supports the following:
 * * `entry` - (Optional, Computed) The CIDR blocks.
 * * `comment` - (Optional, Computed) The comment of the entry.
 * ## Import
 * Server Load balancer access control list can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:slb/acl:Acl example acl-abc123456
 * ```
 * @property entryLists A list of entry (CIDR blocks) to be added. It contains two sub-fields as `Entry Block` follows. **NOTE:** "Field 'entry_list' has been deprecated from provider version 1.162.0 and it will be removed in the future version. Please use the new resource 'alicloud_slb_acl_entry_attachment'.",
 * @property ipVersion The IP Version of access control list is the type of its entry (IP addresses or CIDR blocks). It values ipv4/ipv6. Our plugin provides a default ip_version: "ipv4".
 * @property name Name of the access control list.
 * @property resourceGroupId Resource group ID.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class AclArgs(
    @Deprecated(
        message = """
  Field 'entry_list' has been deprecated from provider version 1.162.0 and it will be removed in the
      future version. Please use the new resource 'alicloud_slb_acl_entry_attachment'.
  """,
    )
    public val entryLists: Output<List<AclEntryListArgs>>? = null,
    public val ipVersion: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.slb.AclArgs> {
    override fun toJava(): com.pulumi.alicloud.slb.AclArgs = com.pulumi.alicloud.slb.AclArgs.builder()
        .entryLists(
            entryLists?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .ipVersion(ipVersion?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [AclArgs].
 */
@PulumiTagMarker
public class AclArgsBuilder internal constructor() {
    private var entryLists: Output<List<AclEntryListArgs>>? = null

    private var ipVersion: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A list of entry (CIDR blocks) to be added. It contains two sub-fields as `Entry Block` follows. **NOTE:** "Field 'entry_list' has been deprecated from provider version 1.162.0 and it will be removed in the future version. Please use the new resource 'alicloud_slb_acl_entry_attachment'.",
     */
    @Deprecated(
        message = """
  Field 'entry_list' has been deprecated from provider version 1.162.0 and it will be removed in the
      future version. Please use the new resource 'alicloud_slb_acl_entry_attachment'.
  """,
    )
    @JvmName("rpkawsyucttwbjsi")
    public suspend fun entryLists(`value`: Output<List<AclEntryListArgs>>) {
        this.entryLists = value
    }

    @JvmName("vxhnhcruspnvpovu")
    public suspend fun entryLists(vararg values: Output<AclEntryListArgs>) {
        this.entryLists = Output.all(values.asList())
    }

    /**
     * @param values A list of entry (CIDR blocks) to be added. It contains two sub-fields as `Entry Block` follows. **NOTE:** "Field 'entry_list' has been deprecated from provider version 1.162.0 and it will be removed in the future version. Please use the new resource 'alicloud_slb_acl_entry_attachment'.",
     */
    @Deprecated(
        message = """
  Field 'entry_list' has been deprecated from provider version 1.162.0 and it will be removed in the
      future version. Please use the new resource 'alicloud_slb_acl_entry_attachment'.
  """,
    )
    @JvmName("xpaiiayjllgmpusf")
    public suspend fun entryLists(values: List<Output<AclEntryListArgs>>) {
        this.entryLists = Output.all(values)
    }

    /**
     * @param value The IP Version of access control list is the type of its entry (IP addresses or CIDR blocks). It values ipv4/ipv6. Our plugin provides a default ip_version: "ipv4".
     */
    @JvmName("dynlvfjdpronlkmq")
    public suspend fun ipVersion(`value`: Output<String>) {
        this.ipVersion = value
    }

    /**
     * @param value Name of the access control list.
     */
    @JvmName("jjyokjrepvwaynfh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Resource group ID.
     */
    @JvmName("cuijlocomcelrqmw")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("vxmarfjcydmskofy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A list of entry (CIDR blocks) to be added. It contains two sub-fields as `Entry Block` follows. **NOTE:** "Field 'entry_list' has been deprecated from provider version 1.162.0 and it will be removed in the future version. Please use the new resource 'alicloud_slb_acl_entry_attachment'.",
     */
    @Deprecated(
        message = """
  Field 'entry_list' has been deprecated from provider version 1.162.0 and it will be removed in the
      future version. Please use the new resource 'alicloud_slb_acl_entry_attachment'.
  """,
    )
    @JvmName("apftjvxdtkjlidhf")
    public suspend fun entryLists(`value`: List<AclEntryListArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entryLists = mapped
    }

    /**
     * @param argument A list of entry (CIDR blocks) to be added. It contains two sub-fields as `Entry Block` follows. **NOTE:** "Field 'entry_list' has been deprecated from provider version 1.162.0 and it will be removed in the future version. Please use the new resource 'alicloud_slb_acl_entry_attachment'.",
     */
    @Deprecated(
        message = """
  Field 'entry_list' has been deprecated from provider version 1.162.0 and it will be removed in the
      future version. Please use the new resource 'alicloud_slb_acl_entry_attachment'.
  """,
    )
    @JvmName("owspnjlyfdhxjorc")
    public suspend fun entryLists(argument: List<suspend AclEntryListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AclEntryListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.entryLists = mapped
    }

    /**
     * @param argument A list of entry (CIDR blocks) to be added. It contains two sub-fields as `Entry Block` follows. **NOTE:** "Field 'entry_list' has been deprecated from provider version 1.162.0 and it will be removed in the future version. Please use the new resource 'alicloud_slb_acl_entry_attachment'.",
     */
    @Deprecated(
        message = """
  Field 'entry_list' has been deprecated from provider version 1.162.0 and it will be removed in the
      future version. Please use the new resource 'alicloud_slb_acl_entry_attachment'.
  """,
    )
    @JvmName("cncedbmpuqqtpfru")
    public suspend fun entryLists(vararg argument: suspend AclEntryListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AclEntryListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.entryLists = mapped
    }

    /**
     * @param argument A list of entry (CIDR blocks) to be added. It contains two sub-fields as `Entry Block` follows. **NOTE:** "Field 'entry_list' has been deprecated from provider version 1.162.0 and it will be removed in the future version. Please use the new resource 'alicloud_slb_acl_entry_attachment'.",
     */
    @Deprecated(
        message = """
  Field 'entry_list' has been deprecated from provider version 1.162.0 and it will be removed in the
      future version. Please use the new resource 'alicloud_slb_acl_entry_attachment'.
  """,
    )
    @JvmName("thvpkwucbqjcpyqv")
    public suspend fun entryLists(argument: suspend AclEntryListArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AclEntryListArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.entryLists = mapped
    }

    /**
     * @param values A list of entry (CIDR blocks) to be added. It contains two sub-fields as `Entry Block` follows. **NOTE:** "Field 'entry_list' has been deprecated from provider version 1.162.0 and it will be removed in the future version. Please use the new resource 'alicloud_slb_acl_entry_attachment'.",
     */
    @Deprecated(
        message = """
  Field 'entry_list' has been deprecated from provider version 1.162.0 and it will be removed in the
      future version. Please use the new resource 'alicloud_slb_acl_entry_attachment'.
  """,
    )
    @JvmName("edxbnpwqoelyddih")
    public suspend fun entryLists(vararg values: AclEntryListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entryLists = mapped
    }

    /**
     * @param value The IP Version of access control list is the type of its entry (IP addresses or CIDR blocks). It values ipv4/ipv6. Our plugin provides a default ip_version: "ipv4".
     */
    @JvmName("ygepcbfeeqbexxmk")
    public suspend fun ipVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipVersion = mapped
    }

    /**
     * @param value Name of the access control list.
     */
    @JvmName("ujicowjqngwoqecp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Resource group ID.
     */
    @JvmName("pxqruparmoxvuxnl")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("iionrkdfcxjhrskf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("jglrfluwfhfpmjnn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AclArgs = AclArgs(
        entryLists = entryLists,
        ipVersion = ipVersion,
        name = name,
        resourceGroupId = resourceGroupId,
        tags = tags,
    )
}
