@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AclEntryAttachment].
 */
@PulumiTagMarker
public class AclEntryAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AclEntryAttachmentArgs = AclEntryAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AclEntryAttachmentArgsBuilder.() -> Unit) {
        val builder = AclEntryAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AclEntryAttachment {
        val builtJavaResource = com.pulumi.alicloud.slb.AclEntryAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AclEntryAttachment(builtJavaResource)
    }
}

/**
 * > **NOTE:** Available in v1.162.0+.
 * > **NOTE:** The maximum number of entries per acl is 300.
 * For information about acl entry attachment and how to use it, see [Configure an acl entry](https://www.alibabacloud.com/help/en/doc-detail/70023.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const attachment = new alicloud.slb.Acl("attachment", {
 *     name: "forSlbAclEntryAttachment",
 *     ipVersion: "ipv4",
 * });
 * const attachmentAclEntryAttachment = new alicloud.slb.AclEntryAttachment("attachment", {
 *     aclId: attachment.id,
 *     entry: "168.10.10.0/24",
 *     comment: "second",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * attachment = alicloud.slb.Acl("attachment",
 *     name="forSlbAclEntryAttachment",
 *     ip_version="ipv4")
 * attachment_acl_entry_attachment = alicloud.slb.AclEntryAttachment("attachment",
 *     acl_id=attachment.id,
 *     entry="168.10.10.0/24",
 *     comment="second")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var attachment = new AliCloud.Slb.Acl("attachment", new()
 *     {
 *         Name = "forSlbAclEntryAttachment",
 *         IpVersion = "ipv4",
 *     });
 *     var attachmentAclEntryAttachment = new AliCloud.Slb.AclEntryAttachment("attachment", new()
 *     {
 *         AclId = attachment.Id,
 *         Entry = "168.10.10.0/24",
 *         Comment = "second",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		attachment, err := slb.NewAcl(ctx, "attachment", &slb.AclArgs{
 * 			Name:      pulumi.String("forSlbAclEntryAttachment"),
 * 			IpVersion: pulumi.String("ipv4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = slb.NewAclEntryAttachment(ctx, "attachment", &slb.AclEntryAttachmentArgs{
 * 			AclId:   attachment.ID(),
 * 			Entry:   pulumi.String("168.10.10.0/24"),
 * 			Comment: pulumi.String("second"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.slb.Acl;
 * import com.pulumi.alicloud.slb.AclArgs;
 * import com.pulumi.alicloud.slb.AclEntryAttachment;
 * import com.pulumi.alicloud.slb.AclEntryAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var attachment = new Acl("attachment", AclArgs.builder()
 *             .name("forSlbAclEntryAttachment")
 *             .ipVersion("ipv4")
 *             .build());
 *         var attachmentAclEntryAttachment = new AclEntryAttachment("attachmentAclEntryAttachment", AclEntryAttachmentArgs.builder()
 *             .aclId(attachment.id())
 *             .entry("168.10.10.0/24")
 *             .comment("second")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   attachment:
 *     type: alicloud:slb:Acl
 *     properties:
 *       name: forSlbAclEntryAttachment
 *       ipVersion: ipv4
 *   attachmentAclEntryAttachment:
 *     type: alicloud:slb:AclEntryAttachment
 *     name: attachment
 *     properties:
 *       aclId: ${attachment.id}
 *       entry: 168.10.10.0/24
 *       comment: second
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Acl entry attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:slb/aclEntryAttachment:AclEntryAttachment example <acl_id>:<entry>
 * ```
 */
public class AclEntryAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.slb.AclEntryAttachment,
) : KotlinCustomResource(javaResource, AclEntryAttachmentMapper) {
    /**
     * The ID of the Acl.
     */
    public val aclId: Output<String>
        get() = javaResource.aclId().applyValue({ args0 -> args0 })

    /**
     * The comment of the entry.
     */
    public val comment: Output<String>?
        get() = javaResource.comment().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The CIDR blocks.
     */
    public val entry: Output<String>
        get() = javaResource.entry().applyValue({ args0 -> args0 })
}

public object AclEntryAttachmentMapper : ResourceMapper<AclEntryAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.slb.AclEntryAttachment::class == javaResource::class

    override fun map(javaResource: Resource): AclEntryAttachment = AclEntryAttachment(
        javaResource as
            com.pulumi.alicloud.slb.AclEntryAttachment,
    )
}

/**
 * @see [AclEntryAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AclEntryAttachment].
 */
public suspend fun aclEntryAttachment(
    name: String,
    block: suspend AclEntryAttachmentResourceBuilder.() -> Unit,
): AclEntryAttachment {
    val builder = AclEntryAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AclEntryAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun aclEntryAttachment(name: String): AclEntryAttachment {
    val builder = AclEntryAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
