@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin

import com.pulumi.alicloud.slb.AclEntryAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * > **NOTE:** Available in v1.162.0+.
 * > **NOTE:** The maximum number of entries per acl is 300.
 * For information about acl entry attachment and how to use it, see [Configure an acl entry](https://www.alibabacloud.com/help/en/doc-detail/70023.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const attachment = new alicloud.slb.Acl("attachment", {
 *     name: "forSlbAclEntryAttachment",
 *     ipVersion: "ipv4",
 * });
 * const attachmentAclEntryAttachment = new alicloud.slb.AclEntryAttachment("attachment", {
 *     aclId: attachment.id,
 *     entry: "168.10.10.0/24",
 *     comment: "second",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * attachment = alicloud.slb.Acl("attachment",
 *     name="forSlbAclEntryAttachment",
 *     ip_version="ipv4")
 * attachment_acl_entry_attachment = alicloud.slb.AclEntryAttachment("attachment",
 *     acl_id=attachment.id,
 *     entry="168.10.10.0/24",
 *     comment="second")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var attachment = new AliCloud.Slb.Acl("attachment", new()
 *     {
 *         Name = "forSlbAclEntryAttachment",
 *         IpVersion = "ipv4",
 *     });
 *     var attachmentAclEntryAttachment = new AliCloud.Slb.AclEntryAttachment("attachment", new()
 *     {
 *         AclId = attachment.Id,
 *         Entry = "168.10.10.0/24",
 *         Comment = "second",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		attachment, err := slb.NewAcl(ctx, "attachment", &slb.AclArgs{
 * 			Name:      pulumi.String("forSlbAclEntryAttachment"),
 * 			IpVersion: pulumi.String("ipv4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = slb.NewAclEntryAttachment(ctx, "attachment", &slb.AclEntryAttachmentArgs{
 * 			AclId:   attachment.ID(),
 * 			Entry:   pulumi.String("168.10.10.0/24"),
 * 			Comment: pulumi.String("second"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.slb.Acl;
 * import com.pulumi.alicloud.slb.AclArgs;
 * import com.pulumi.alicloud.slb.AclEntryAttachment;
 * import com.pulumi.alicloud.slb.AclEntryAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var attachment = new Acl("attachment", AclArgs.builder()
 *             .name("forSlbAclEntryAttachment")
 *             .ipVersion("ipv4")
 *             .build());
 *         var attachmentAclEntryAttachment = new AclEntryAttachment("attachmentAclEntryAttachment", AclEntryAttachmentArgs.builder()
 *             .aclId(attachment.id())
 *             .entry("168.10.10.0/24")
 *             .comment("second")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   attachment:
 *     type: alicloud:slb:Acl
 *     properties:
 *       name: forSlbAclEntryAttachment
 *       ipVersion: ipv4
 *   attachmentAclEntryAttachment:
 *     type: alicloud:slb:AclEntryAttachment
 *     name: attachment
 *     properties:
 *       aclId: ${attachment.id}
 *       entry: 168.10.10.0/24
 *       comment: second
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Acl entry attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:slb/aclEntryAttachment:AclEntryAttachment example <acl_id>:<entry>
 * ```
 * @property aclId The ID of the Acl.
 * @property comment The comment of the entry.
 * @property entry The CIDR blocks.
 */
public data class AclEntryAttachmentArgs(
    public val aclId: Output<String>? = null,
    public val comment: Output<String>? = null,
    public val entry: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.slb.AclEntryAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.slb.AclEntryAttachmentArgs =
        com.pulumi.alicloud.slb.AclEntryAttachmentArgs.builder()
            .aclId(aclId?.applyValue({ args0 -> args0 }))
            .comment(comment?.applyValue({ args0 -> args0 }))
            .entry(entry?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AclEntryAttachmentArgs].
 */
@PulumiTagMarker
public class AclEntryAttachmentArgsBuilder internal constructor() {
    private var aclId: Output<String>? = null

    private var comment: Output<String>? = null

    private var entry: Output<String>? = null

    /**
     * @param value The ID of the Acl.
     */
    @JvmName("xmqpisgohvphgcct")
    public suspend fun aclId(`value`: Output<String>) {
        this.aclId = value
    }

    /**
     * @param value The comment of the entry.
     */
    @JvmName("fgmhetgqxpxjbtpp")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value The CIDR blocks.
     */
    @JvmName("jgpyumswrsbiyuig")
    public suspend fun entry(`value`: Output<String>) {
        this.entry = value
    }

    /**
     * @param value The ID of the Acl.
     */
    @JvmName("shcfvqyeqgxvsbly")
    public suspend fun aclId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclId = mapped
    }

    /**
     * @param value The comment of the entry.
     */
    @JvmName("klbxeacutfnavwed")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value The CIDR blocks.
     */
    @JvmName("wvncsvjxpfressrl")
    public suspend fun entry(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entry = mapped
    }

    internal fun build(): AclEntryAttachmentArgs = AclEntryAttachmentArgs(
        aclId = aclId,
        comment = comment,
        entry = entry,
    )
}
